<?php
// Show PHP errors during development
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include DB connection
include('../../db.php'); // Adjust if your db.php is in a different path

// Handle video link submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $video_link = trim($_POST['video_link']);

    if (!empty($video_link)) {
        $stmt = $conn->prepare("INSERT INTO videos (video_link) VALUES (:video_link)");
        $stmt->execute(['video_link' => $video_link]);

        echo "<script>
            alert('Video link added successfully!');
            window.location.href = 'videos.php';
        </script>";
        exit;
    } else {
        echo "<script>alert('Please enter a valid video link');</script>";
    }
}

// Fetch all videos
$stmt = $conn->query("SELECT * FROM videos ORDER BY id DESC");
$videos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin - Add Videos</title>
    <style>
        body {
            font-family: Arial;
            background: #f0f0f0;
            padding: 30px;
        }
        .container {
            max-width: 600px;
            background: white;
            padding: 20px;
            border-radius: 8px;
            margin: auto;
            box-shadow: 0 0 10px #ccc;
        }
        input[type="text"] {
            width: 100%;
            padding: 10px;
            margin: 12px 0;
            border: 1px solid #aaa;
            border-radius: 4px;
        }
        button {
            background: maroon;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        button:hover {
            background: darkred;
        }
        ul {
            padding-left: 20px;
        }
        li {
            margin-bottom: 10px;
        }
        a {
            color: blue;
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Add Video Link</h2>
        <form method="POST">
            <label for="video_link">YouTube or Video Link:</label>
            <input type="text" name="video_link" id="video_link" required placeholder="https://www.youtube.com/watch?v=...">
            <button type="submit">Add Video</button>
        </form>

        <hr>

        <h3>All Videos</h3>
        <ul>
            <?php if (count($videos) > 0): ?>
                <?php foreach ($videos as $video): ?>
                    <li>
                        <a href="<?= htmlspecialchars($video['video_link']) ?>" target="_blank">
                            <?= htmlspecialchars($video['video_link']) ?>
                        </a>
                    </li>
                <?php endforeach; ?>
            <?php else: ?>
                <p>No videos added yet.</p>
            <?php endif; ?>
        </ul>
    </div>
</body>
</html>