<?php
session_start();
include '../../db.php';

// Admin access check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit();
}

// Handle delete
if (isset($_GET['delete'])) {
    $videoId = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM videos WHERE id = ?");
    $stmt->execute([$videoId]);
    header("Location: admin_video_list.php");
    exit;
}

// Fetch videos with VIP product names
$stmt = $conn->prepare("
    SELECT v.id, v.title, v.video_url, p.name AS vip_name
    FROM videos v
    JOIN vip_products p ON v.vip_product_id = p.id
    ORDER BY v.id DESC
");
$stmt->execute();
$videos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin Video List</title>
    <style>
        body { background: #111; color: #fff; font-family: Arial; padding: 20px; }
        h2 { text-align: center; }
        table { width: 100%; background: #222; border-collapse: collapse; margin-top: 20px; }
        th, td { padding: 10px; border: 1px solid #444; text-align: left; }
        a.delete { color: red; text-decoration: none; }
        a.delete:hover { text-decoration: underline; }
    </style>
</head>
<body>

<h2>Uploaded Videos</h2>

<table>
    <tr>
        <th>ID</th>
        <th>Title</th>
        <th>VIP Tier</th>
        <th>Preview</th>
        <th>Action</th>
    </tr>
    <?php foreach ($videos as $video): ?>
    <tr>
        <td><?= $video['id'] ?></td>
        <td><?= htmlspecialchars($video['title']) ?></td>
        <td><?= htmlspecialchars($video['vip_name']) ?></td>
        <td>
            <iframe width="200" height="100" src="<?= htmlspecialchars($video['video_url']) ?>" frameborder="0" allowfullscreen></iframe>
        </td>
        <td>
            <a class="delete" href="?delete=<?= $video['id'] ?>" onclick="return confirm('Delete this video?');">Delete</a>
        </td>
    </tr>
    <?php endforeach; ?>
</table>

</body>
</html>