<?php
session_start();
include 'admin_db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vipId = $_POST['vip_id'];
    $image = $_FILES['image'];

    if ($image && $image['error'] == 0) {
        $ext = pathinfo($image['name'], PATHINFO_EXTENSION);
        $clean_name = preg_replace('/[^a-zA-Z0-9_\.-]/', '_', $image['name']);
        $filename = uniqid('vip_', true) . '_' . $clean_name;
        $upload_dir = __DIR__ . '/../../../uploads/';
        $targetPath = $upload_dir . $filename;

        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }

        if (move_uploaded_file($image['tmp_name'], $targetPath)) {
            $stmt = $conn->prepare("UPDATE vip_products SET img = ? WHERE id = ?");
            $stmt->execute([$filename, $vipId]);
            $success = "✅ Image uploaded successfully and VIP product updated.";
        } else {
            $error = "❌ Failed to move uploaded file.";
        }
    } else {
        $error = "❌ Please select a valid image file.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Upload VIP Image</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-white min-h-screen flex items-center justify-center">
  <div class="bg-gray-800 p-8 rounded-xl shadow-lg w-full max-w-md">
    <h2 class="text-xl font-bold mb-6 text-center text-[#caa076]">Upload VIP Product Image</h2>

    <?php if (!empty($success)): ?>
      <div class="bg-green-600 text-white px-4 py-2 rounded mb-4"><?= $success ?></div>
    <?php endif; ?>
    <?php if (!empty($error)): ?>
      <div class="bg-red-600 text-white px-4 py-2 rounded mb-4"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST" enctype="multipart/form-data" class="space-y-4">
      <div>
        <label class="block mb-1 font-medium">Select VIP Product</label>
        <select name="vip_id" required class="w-full bg-gray-700 rounded px-4 py-2">
          <?php
          $stmt = $conn->query("SELECT id, name FROM vip_products");
          while ($row = $stmt->fetch()) {
              echo "<option value='{$row['id']}'>{$row['name']}</option>";
          }
          ?>
        </select>
      </div>

      <div>
        <label class="block mb-1 font-medium">Choose Image</label>
        <input type="file" name="image" accept="image/*" required class="w-full bg-gray-700 rounded px-4 py-2 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:bg-[#caa076] file:text-white">
      </div>

      <button type="submit" class="w-full bg-[#caa076] hover:bg-[#b88a61] text-white font-bold py-2 px-4 rounded-full">
        Upload Image
      </button>
    </form>
  </div>
</body>
</html>