<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
include('admin_db.php');

// Fetch VIPs
$vip_stmt = $conn->prepare("SELECT id, name FROM vip_products ORDER BY id ASC");
$vip_stmt->execute();
$vip_products = $vip_stmt->fetchAll();

function createFolderIfNotExist($path) {
    if (!is_dir($path)) {
        mkdir($path, 0755, true);
    }
}

createFolderIfNotExist('../../../uploads/videos/');
createFolderIfNotExist('../../../uploads/thumbnails/');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $_POST['title'] ?? '';
    $vip_product_id = $_POST['vip_product_id'] ?? '';
    $video_link = trim($_POST['video_link'] ?? '');

    $video_url = '';
    $thumbnail_url = '';

    if ($vip_product_id && $title) {
        if (!empty($video_link)) {
            // Use pasted link directly
            $video_url = $video_link;
            $thumbnail_url = ''; // You can add thumbnail fetching for YouTube/Streamable if needed
        } elseif (!empty($_FILES['video']['tmp_name'])) {
            // Upload local video
            $video_name = time() . '_' . basename($_FILES['video']['name']);
            $video_path = '../../../uploads/videos/' . $video_name;
            $video_url = '/uploads/videos/' . $video_name;
            move_uploaded_file($_FILES['video']['tmp_name'], $video_path);

            // Generate thumbnail
            $thumbnail_name = time() . '_thumb.jpg';
            $thumbnail_path = '../../../uploads/thumbnails/' . $thumbnail_name;
            $thumbnail_url = '/uploads/thumbnails/' . $thumbnail_name;

            $ffmpeg_cmd = "ffmpeg -i \"$video_path\" -ss 00:00:03 -vframes 1 \"$thumbnail_path\"";
            exec($ffmpeg_cmd);
        }

        if ($video_url) {
            $stmt = $conn->prepare("INSERT INTO videos (title, video_url, vip_product_id, thumbnail) VALUES (?, ?, ?, ?)");
            $stmt->execute([$title, $video_url, $vip_product_id, $thumbnail_url]);
            echo "<p style='color:lime;'>✅ Video uploaded successfully!</p>";
        } else {
            echo "<p style='color:red;'>❌ No video link or file uploaded.</p>";
        }
    } else {
        echo "<p style='color:red;'>❌ All fields are required.</p>";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Upload VIP Video</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { background-color: #111; color: white; font-family: Arial; padding: 20px; }
        form { background-color: #1e1e1e; padding: 20px; border-radius: 10px; }
        input, select, textarea { width: 100%; padding: 10px; margin: 10px 0; background: #2a2a2a; color: white; border: none; border-radius: 5px; }
        button { background-color: #caa076; color: black; padding: 10px; border: none; border-radius: 5px; font-weight: bold; cursor: pointer; }
        button:hover { opacity: 0.9; }
        label { margin-top: 10px; display: block; }
        small { color: #888; display: block; margin-top: -8px; margin-bottom: 10px; }
    </style>
</head>
<body>

<h2>🎥 Upload or Paste VIP Task Video</h2>

<form method="POST" enctype="multipart/form-data">
    <label>Video Title</label>
    <input type="text" name="title" required>

    <label>Select VIP</label>
    <select name="vip_product_id" required>
        <option value="">-- Choose VIP --</option>
        <?php foreach ($vip_products as $vip): ?>
            <option value="<?= $vip['id'] ?>"><?= htmlspecialchars($vip['name']) ?></option>
        <?php endforeach; ?>
    </select>

    <label>Paste Video Link (YouTube / Streamable / Direct MP4)</label>
    <input type="url" name="video_link" placeholder="https://example.com/video.mp4">
    <small>Or upload a video below (if no link is pasted)</small>

    <label>Upload MP4 Video</label>
    <input type="file" name="video" accept="video/mp4">

    <button type="submit">Upload Video</button>
</form>

</body>
</html>