<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();

if (empty($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}

include 'admin_db.php';

// Handle manual approve
if (isset($_GET['approve']) && is_numeric($_GET['approve'])) {
    $id = intval($_GET['approve']);
    try {
        // fetch order info first
        $stmt = $conn->prepare("SELECT phone, amount, status FROM recharge_records WHERE id = :id");
        $stmt->execute([':id' => $id]);
        $order = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($order && $order['status'] === 'pending') {
            // update recharge record
            $stmt2 = $conn->prepare("UPDATE recharge_records SET status = 'approved' WHERE id = :id");
            $stmt2->execute([':id' => $id]);

            // credit user wallet
            $stmt3 = $conn->prepare("UPDATE users SET balance = balance + :amount WHERE phone = :phone");
            $stmt3->execute([
                ':amount' => $order['amount'],
                ':phone'  => $order['phone']
            ]);

            header("Location: admin_recharges.php?success=1");
            exit;
        } else {
            header("Location: admin_recharges.php?error=Invalid+Order");
            exit;
        }

    } catch (PDOException $e) {
        die("Error approving recharge: " . $e->getMessage());
    }
}

// Fetch recharge records (QePay, KBPay, OTPPay, Recharge Naira)
try {
    $stmt = $conn->prepare("
        SELECT id, merchant_order_id, phone, amount, payment_method, status, created_at 
        FROM recharge_records 
        WHERE LOWER(payment_method) IN ('qepay','kbpay','otppay','recharge (naira)')
        ORDER BY created_at DESC
    ");
    $stmt->execute();
    $recharges = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Error fetching recharges: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Recharge Records - Admin</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body { font-family: Arial, sans-serif; background: #0d0d0d; color: #fff; margin: 0; padding: 0; }
h2 { text-align:center; margin:20px 0; color:#c69c72; }
table { width: 95%; margin: 20px auto; border-collapse: collapse; background:#1a1a1a; border-radius:8px; overflow:hidden; }
th, td { padding: 12px 15px; border: 1px solid #444; text-align: center; }
th { background: #c69c72; color: #0d0d0d; font-weight: bold; }
tr:nth-child(even) { background: #111; }
a.btn { padding: 6px 12px; background: #28a745; color: #fff; text-decoration: none; border-radius: 4px; }
a.btn:hover { background: #218838; }
.status-pending { color: orange; font-weight: bold; }
.status-approved { color: lightgreen; font-weight: bold; }
</style>
</head>
<body>
<h2>Recharge Records - All Gateways</h2>

<?php if (isset($_GET['success'])): ?>
    <p style="color:lightgreen; text-align:center;">Recharge approved successfully!</p>
<?php elseif (isset($_GET['error'])): ?>
    <p style="color:red; text-align:center;">Error: <?php echo htmlspecialchars($_GET['error']); ?></p>
<?php endif; ?>

<table>
<thead>
<tr>
<th>ID</th>
<th>Order Number</th>
<th>User Phone</th>
<th>Amount (₦)</th>
<th>Payment Method</th>
<th>Status</th>
<th>Date</th>
<th>Action</th>
</tr>
</thead>
<tbody>
<?php if (!empty($recharges)): ?>
    <?php foreach ($recharges as $r): ?>
        <tr>
            <td><?php echo htmlspecialchars($r['id']); ?></td>
            <td><?php echo htmlspecialchars($r['merchant_order_id']); ?></td>
            <td><?php echo htmlspecialchars($r['phone']); ?></td>
            <td><?php echo number_format($r['amount'], 2); ?></td>
            <td><?php echo strtoupper(htmlspecialchars($r['payment_method'])); ?></td>
            <td class="status-<?php echo htmlspecialchars($r['status']); ?>">
                <?php echo ucfirst($r['status']); ?>
            </td>
            <td><?php echo htmlspecialchars($r['created_at']); ?></td>
            <td>
                <?php if ($r['status'] === 'pending'): ?>
                    <a class="btn" href="?approve=<?php echo $r['id']; ?>" onclick="return confirm('Approve this recharge manually?');">Approve</a>
                <?php else: ?>
                    -
                <?php endif; ?>
            </td>
        </tr>
    <?php endforeach; ?>
<?php else: ?>
    <tr><td colspan="8">No recharges found.</td></tr>
<?php endif; ?>
</tbody>
</table>
</body>
</html>