<?php
// Enable full error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

include 'admin_db.php'; // Correct path since file is in same folder

if (!isset($_GET['phone'])) {
    die("No user specified.");
}

$phone = $_GET['phone'];

// Validate input (basic sanitization)
$phone = trim($phone);

// Check if user exists
$stmt = $conn->prepare("SELECT * FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    die("User not found.");
}

// Log in as user
$_SESSION['phone'] = $user['phone'];

// Redirect to user dashboard
header("Location: ../../mine.php");
exit;