<?php
include 'admin_db.php';

$data = $_POST; // KBPay sends POST data

$order_no = $data['order_no'] ?? '';
$status   = $data['status'] ?? ''; // Example: "SUCCESS" or "FAIL"

// Find withdrawal by order_no
$stmt = $conn->prepare("SELECT * FROM withdrawals WHERE order_no=?");
$stmt->execute([$order_no]);
$withdrawal = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$withdrawal) {
    die("Order not found");
}

if ($status === 'SUCCESS') {
    $update = $conn->prepare("UPDATE withdrawals SET status='approved', gateway_response=? WHERE id=?");
    $update->execute([json_encode($data), $withdrawal['id']]);
} else {
    $conn->beginTransaction();
    try {
        $update = $conn->prepare("UPDATE withdrawals SET status='failed', gateway_response=? WHERE id=?");
        $update->execute([json_encode($data), $withdrawal['id']]);

        // refund
        $refund = $conn->prepare("UPDATE users SET balance = balance + ? WHERE id=?");
        $refund->execute([$withdrawal['amount'], $withdrawal['user_id']]);

        $conn->commit();
    } catch (Exception $e) {
        $conn->rollBack();
    }
}

echo "success"; // KBPay expects this