<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// ✅ Include the correct DB connection
include 'admin_db.php'; // Make sure this file contains a valid $conn

// ✅ Get the phone number from URL
$phone = $_GET['phone'] ?? null;

if ($phone) {
    // Check if the user exists and get current ban status
    $stmt = $conn->prepare("SELECT is_banned FROM users WHERE phone = ?");
    $stmt->execute([$phone]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        $newStatus = $user['is_banned'] ? 0 : 1;

        // Update user's banned status
        $update = $conn->prepare("UPDATE users SET is_banned = ? WHERE phone = ?");
        $update->execute([$newStatus, $phone]);

        // Set success message
        $_SESSION['ban_message'] = $newStatus ? "User has been banned." : "User has been unbanned.";
    } else {
        $_SESSION['ban_message'] = "User not found.";
    }
} else {
    $_SESSION['ban_message'] = "Invalid phone number.";
}

// ✅ Redirect back to user list page
header("Location: ../users.php");
exit();