<?php
// approved.php
session_start();
include 'admin_db.php';

if (!isset($_GET['id'])) {
    die("Invalid request");
}

$deposit_id = intval($_GET['id']);

// Get deposit details
$stmt = $conn->prepare("SELECT d.*, u.username 
                        FROM recharge_records d
                        JOIN users u ON d.phone = u.phone
                        WHERE d.id = ?");
$stmt->execute([$deposit_id]);
$deposit = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$deposit) {
    die("Deposit not found");
}

// Handle approval
if (isset($_POST['approve'])) {
    $conn->beginTransaction();

    // Update deposit status
    $stmt = $conn->prepare("UPDATE recharge_records SET status = 'approved' WHERE id = ?");
    $stmt->execute([$deposit_id]);

    // ✅ Credit wallet in NGN, not USDT
    $stmt = $conn->prepare("UPDATE users SET wallet = wallet + ? WHERE phone = ?");
    $stmt->execute([$deposit['amount_ngn'], $deposit['phone']]);

    $conn->commit();

    header("Location: approved.php?success=1");
    exit();
}

// Handle rejection
if (isset($_POST['reject'])) {
    $stmt = $conn->prepare("UPDATE recharge_records SET status = 'rejected' WHERE id = ?");
    $stmt->execute([$deposit_id]);

    header("Location: approved.php?rejected=1");
    exit();
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Approve Deposit</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6">

<div class="max-w-xl mx-auto bg-white rounded-lg shadow p-6">
    <h2 class="text-xl font-bold mb-4">Approve Deposit</h2>

    <p><strong>User:</strong> <?= htmlspecialchars($deposit['username']) ?></p>
    <p><strong>Amount (USDT):</strong> <?= number_format($deposit['amount_usdt'], 2) ?> USDT</p>
    <p><strong>Amount (NGN):</strong> ₦<?= number_format($deposit['amount_ngn'], 2) ?></p>
    <p><strong>Date:</strong> <?= date('m/d/Y H:i:s', strtotime($deposit['created_at'])) ?></p>

    <?php if (!empty($deposit['receipt'])): ?>
        <div class="mt-4">
            <p class="font-semibold mb-2">Uploaded Receipt:</p>
            <img src="/<?= htmlspecialchars($deposit['receipt']) ?>" alt="Receipt" class="border rounded w-full max-h-96 object-contain">
        </div>
    <?php else: ?>
        <p class="text-red-500 mt-4">No receipt uploaded.</p>
    <?php endif; ?>

    <form method="post" class="mt-6 flex gap-4">
        <button name="approve" class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded">Approve</button>
        <button name="reject" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded">Reject</button>
    </form>
</div>

</body>
</html>