<?php
include 'admin_db.php';

// Fetch all withdrawals
$stmt = $conn->query("SELECT w.*, u.phone FROM withdrawals w 
    LEFT JOIN users u ON u.id = w.user_id 
    ORDER BY w.created_at DESC");
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<h2>Withdrawals Management</h2>
<table border="1" cellpadding="8">
    <tr>
        <th>ID</th>
        <th>User Phone</th>
        <th>Type</th>
        <th>Amount</th>
        <th>Fee</th>
        <th>Net Amount</th>
        <th>Details</th>
        <th>Status</th>
        <th>Action</th>
    </tr>

    <?php foreach ($rows as $row): ?>
        <tr>
            <td><?= $row['id'] ?></td>
            <td><?= $row['phone'] ?></td>
            <td><?= strtoupper($row['type']) ?></td>
            <td><?= $row['amount'] ?></td>
            <td><?= $row['fee'] ?></td>
            <td><?= $row['net_amount'] ?></td>
            <td>
                <?php if ($row['type'] === 'usdt'): ?>
                    Wallet: <?= $row['usdt_wallet'] ?>
                <?php else: ?>
                    Bank: <?= $row['bank_name'] ?><br>
                    Acc Name: <?= $row['bank_account_name'] ?><br>
                    Acc No: <?= $row['bank_account_number'] ?>
                <?php endif; ?>
            </td>
            <td><?= ucfirst($row['status']) ?></td>
            <td>
                <?php if ($row['status'] === 'pending'): ?>
                    
                    <!-- Manual Approval -->
                    <a href="approve_withdrawal.php?id=<?= $row['id'] ?>&action=manual">Approve Manual</a> | 
                    
                    <?php if ($row['type'] === 'bank'): ?>
                        <!-- KBPay Approval -->
                        <a href="approve_withdrawal.php?id=<?= $row['id'] ?>&action=kbpay">Approve KBPay</a> |
                    <?php endif; ?>

                    <a href="approve_withdrawal.php?id=<?= $row['id'] ?>&action=reject">Reject</a>
                
                <?php else: ?>
                    <?= ucfirst($row['status']) ?>
                <?php endif; ?>
            </td>
        </tr>
    <?php endforeach; ?>
</table>