<?php    
session_start();    
include 'admin_db.php';    
    
if (!isset($_SESSION['admin_logged_in'])) {    
    header("Location: login.php");    
    exit();    
}    
    
$search = $_GET['search'] ?? '';    
$message = '';    
    
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_user'])) {    
    $phone = $_POST['phone'];    
    $electronic_wallet = floatval($_POST['electronic_wallet']);    
    $flexible_wallet = floatval($_POST['flexible_wallet']);    
    
    $stmt = $conn->prepare("UPDATE users SET electronic_wallet = ?, flexible_wallet = ? WHERE phone = ?");    
    $stmt->execute([$electronic_wallet, $flexible_wallet, $phone]);    
        
    $message = 'User wallet updated successfully!';    
}    
    
if (isset($_GET['ban']) || isset($_GET['unban'])) {    
    $phone = $_GET['ban'] ?? $_GET['unban'];    
    $status = isset($_GET['ban']) ? 1 : 0;    
    $stmt = $conn->prepare("UPDATE users SET is_banned = ? WHERE phone = ?");    
    $stmt->execute([$status, $phone]);    
    header("Location: admin_user.php?search=$phone");    
    exit();    
}    
    
$query = "SELECT * FROM users";    
$params = [];    
    
if (!empty($search)) {    
    $query .= " WHERE phone LIKE ? OR id LIKE ?";    
    $params = ["%$search%", "%$search%"];    
}    
    
$stmt = $conn->prepare($query);    
$stmt->execute($params);    
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);    
?>    <!DOCTYPE html>    <html>    
<head>    
    <title>Admin - User Management</title>    
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>    
    <style>    
        body { font-family: Arial; background: #f5f5f5; padding: 20px; }    
        .card { background: #fff; padding: 20px; border-radius: 10px; margin-bottom: 15px; box-shadow: 0 0 5px rgba(0,0,0,0.1); }    
        .card h3 { margin-top: 0; }    
        .input-group { margin-bottom: 10px; }    
        label { display: block; margin-bottom: 5px; font-weight: bold; }    
        input[type="text"], input[type="number"] { width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 5px; }    
        button { padding: 8px 16px; border: none; border-radius: 5px; background: maroon; color: #fff; cursor: pointer; }    
        .actions { display: flex; gap: 10px; margin-top: 10px; }    
        .search-box { margin-bottom: 20px; }    
        .search-box input { width: 300px; padding: 8px; border-radius: 5px; border: 1px solid #ccc; }    
        .ban-btn { background: crimson; }    
        .unban-btn { background: green; }    
    </style>    
</head>    
<body>    <h2>User Management</h2>    <div class="search-box">    
    <form method="get">    
        <input type="text" name="search" placeholder="Search by phone or ID..." value="<?= htmlspecialchars($search ?? '') ?>">    
        <button type="submit">Search</button>    
    </form>    
</div>    <?php foreach ($users as $user): ?>    <div class="card">    
    <h3><?= htmlspecialchars($user['username']) ?> (<?= htmlspecialchars($user['phone']) ?>)</h3>    
    <p>User ID: <?= htmlspecialchars($user['id']) ?></p>    
    <p>Electronic Wallet: <?= $user['electronic_wallet'] ?> NLC</p>    
    <p>Flexible Wallet: <?= $user['flexible_wallet'] ?> NLC</p>    
    <p>Status: <?= $user['is_banned'] ? '❌ Banned' : '✅ Active' ?></p>    
    <p>Referrer: <?= htmlspecialchars($user['referred_by'] ?? 'None') ?></p>    <form method="post">    
    <input type="hidden" name="phone" value="<?= htmlspecialchars($user['phone']) ?>">    
    <div class="input-group">    
        <label>Electronic Wallet</label>    
        <input type="number" name="electronic_wallet" step="0.01" value="<?= $user['electronic_wallet'] ?>">    
    </div>    
    <div class="input-group">    
        <label>Flexible Wallet</label>    
        <input type="number" name="flexible_wallet" step="0.01" value="<?= $user['flexible_wallet'] ?>">    
    </div>    
    <div class="actions">    
        <button type="submit" name="update_user">Update</button>    
        <a href="ban_user.php?phone=<?= urlencode($user['phone']) ?>">    
<button type="button" class="<?= $user['is_banned'] ? 'unban-btn' : 'ban-btn' ?>">    
    <?= $user['is_banned'] ? 'Unban' : 'Ban' ?>    
</button>

</a>    
            <a href="login_as_user.php?phone=<?= urlencode($user['phone']) ?>" class="btn btn-primary btn-sm">Login as User</a>    
                <button type="button">Login as User</button>    
            </a>    
        </div>    
    </form>    
</div>    
<?php endforeach; ?>    <?php if ($message): ?>    <script>    
Swal.fire({    
    icon: 'success',    
    title: 'Success',    
    text: '<?= $message ?>',    
    confirmButtonColor: '#800000'    
});    
</script>    <?php endif; ?>    </body>    
</html>    
