<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
include 'admin_db.php';

// ✅ Check if admin is logged in
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit();
}

// ✅ Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userId = $_POST['user_id'];
    $electronic = floatval($_POST['electronic_wallet']);
    $flexible = floatval($_POST['flexible_wallet']);

    $stmt = $conn->prepare("UPDATE users SET electronic_wallet = :electronic, flexible_wallet = :flexible WHERE id = :id");
    $stmt->execute([
        ':electronic' => $electronic,
        ':flexible' => $flexible,
        ':id' => $userId
    ]);

    $_SESSION['message'] = "Wallets updated successfully!";
    header("Location: admin_users.php");
    exit();
}

// ✅ Fetch all users
$stmt = $conn->prepare("SELECT id, phone, full_name, electronic_wallet, flexible_wallet FROM users ORDER BY id DESC");
$stmt->execute();
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin - Manage Users</title>
    <style>
        table { border-collapse: collapse; width: 100%; margin-top: 20px; }
        th, td { border: 1px solid #aaa; padding: 10px; text-align: left; }
        form { margin: 0; }
    </style>
</head>
<body>

<h2>User Management</h2>

<?php if (isset($_SESSION['message'])): ?>
    <p style="color:green;"><?php echo $_SESSION['message']; unset($_SESSION['message']); ?></p>
<?php endif; ?>

<table>
    <thead>
        <tr>
            <th>ID</th>
            <th>Phone</th>
            <th>Full Name</th>
            <th>Electronic Wallet</th>
            <th>Flexible Wallet</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($users as $user): ?>
        <tr>
            <form method="POST" action="admin_users.php">
                <td><?php echo $user['id']; ?></td>
                <td><?php echo htmlspecialchars($user['phone']); ?></td>
                <td><?php echo htmlspecialchars($user['full_name']); ?></td>
                <td>
                    <input type="number" step="0.01" name="electronic_wallet" value="<?php echo $user['electronic_wallet']; ?>">
                </td>
                <td>
                    <input type="number" step="0.01" name="flexible_wallet" value="<?php echo $user['flexible_wallet']; ?>">
                </td>
                <td>
                    <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                    <button type="submit">Update</button>
                </td>
            </form>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

</body>
</html>