?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: admin_login.php");
    exit();
}

require '../db.php'; // Make sure this path is correct

$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = $_POST['title'];
    
    if (isset($_FILES['video']) && $_FILES['video']['error'] === 0) {
        $targetDir = "../uploads/videos/";
        if (!is_dir($targetDir)) mkdir($targetDir, 0755, true);

        $fileName = basename($_FILES["video"]["name"]);
        $targetFile = $targetDir . time() . "_" . $fileName;
        $fileType = strtolower(pathinfo($targetFile, PATHINFO_EXTENSION));
        $allowed = ['mp4', 'webm', 'ogg'];

        if (in_array($fileType, $allowed)) {
            if (move_uploaded_file($_FILES["video"]["tmp_name"], $targetFile)) {
                $stmt = $conn->prepare("INSERT INTO videos (title, file_path) VALUES (?, ?)");
                $stmt->execute([$title, $targetFile]);
                $success = "Video uploaded successfully!";
            } else {
                $error = "Failed to upload video.";
            }
        } else {
            $error = "Invalid file format. Allowed: mp4, webm, ogg.";
        }
    } else {
        $error = "No video selected.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Upload Video</title>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <style>
    body {
      background-color: #111;
      color: #fff;
      font-family: Arial;
      padding: 30px;
    }
    input, button {
      padding: 10px;
      margin: 10px 0;
      width: 100%;
      font-size: 16px;
    }
    button {
      background-color: #800000;
      color: white;
      border: none;
      cursor: pointer;
    }
  </style>
</head>
<body>

  <h2>Upload New Video</h2>
  <form method="POST" enctype="multipart/form-data">
    <label>Video Title:</label>
    <input type="text" name="title" required>

    <label>Select Video File:</label>
    <input type="file" name="video" accept="video/*" required>

    <button type="submit">Upload Video</button>
  </form>

  <?php if ($success): ?>
    <script>
      Swal.fire({
        icon: 'success',
        title: 'Success',
        text: '<?= $success ?>',
        confirmButtonColor: '#800000'
      });
    </script>
  <?php elseif ($error): ?>
    <script>
      Swal.fire({
        icon: 'error',
        title: 'Error',
        text: '<?= $error ?>',
        confirmButtonColor: '#800000'
      });
    </script>
  <?php endif; ?>

</body>
</html>