<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
include 'admin_db.php';

// Optional: admin authentication check here

// Handle add
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['phone_number'])) {
    $number = trim($_POST['phone_number']);
    if ($number) {
        $stmt = $conn->prepare("INSERT INTO support_numbers (phone_number) VALUES (?)");
        $stmt->execute([$number]);
    }
}

// Handle delete
if (isset($_GET['delete'])) {
    $delId = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM support_numbers WHERE id = ?");
    $stmt->execute([$delId]);
}

// Fetch support numbers
$stmt = $conn->prepare("SELECT * FROM support_numbers ORDER BY created_at DESC");
$stmt->execute();
$supportNumbers = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin Support Numbers</title>
    <style>
        body {
            background: #000;
            color: #fff;
            font-family: Arial, sans-serif;
            padding: 20px;
        }
        input[type="text"] {
            padding: 10px;
            width: 60%;
            border-radius: 5px;
            border: none;
        }
        button {
            padding: 10px 15px;
            border: none;
            background: green;
            color: white;
            border-radius: 5px;
        }
        table {
            margin-top: 20px;
            width: 100%;
            color: white;
        }
        th, td {
            padding: 10px;
        }
        .delete {
            color: red;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <h2>Manage Support Phone Numbers</h2>
    <form method="POST">
        <input type="text" name="phone_number" placeholder="Enter phone number" required>
        <button type="submit">Add Number</button>
    </form>

    <table>
        <tr><th>ID</th><th>Phone Number</th><th>Action</th></tr>
        <?php foreach ($supportNumbers as $row): ?>
            <tr>
                <td><?= $row['id'] ?></td>
                <td><?= htmlspecialchars($row['phone_number']) ?></td>
                <td><a href="?delete=<?= $row['id'] ?>" class="delete" onclick="return confirm('Delete this number?')">Delete</a></td>
            </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>