<?php
// admin_recharges.php
session_start();
include 'admin_db.php';

// Fetch pending recharges
$stmt = $conn->prepare("SELECT * FROM recharge_records WHERE status = 'pending' ORDER BY created_at DESC");
$stmt->execute();
$recharges = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
  <title>Pending Recharges</title>
  <link href="https://cdn.tailwindcss.com" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body class="bg-gray-100 p-6">
  <div class="max-w-5xl mx-auto bg-white rounded shadow p-6">
    <h2 class="text-2xl font-bold mb-4">Pending Recharge Requests</h2>

    <table class="w-full table-auto text-sm border-collapse">
      <thead class="bg-gray-200">
        <tr>
          <th class="border p-2">Phone</th>
          <th class="border p-2">Amount</th>
          <th class="border p-2">Date</th>
          <th class="border p-2">Receipt</th>
          <th class="border p-2">Action</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($recharges as $r): ?>
          <tr class="text-center">
            <td class="border p-2"><?= htmlspecialchars($r['phone'] ?? '') ?></td>
            <td class="border p-2">$<?= number_format($r['amount'], 2) ?></td>
            <td class="border p-2"><?= date('m/d/Y H:i:s', strtotime($r['created_at'])) ?></td>
            <td class="border p-2">
              <?php if (!empty($r['receipt'])): ?>
                <a href="<?= htmlspecialchars('../../' . $r['receipt']) ?>" target="_blank" class="text-blue-500 underline">View</a>
              <?php else: ?>
                <span class="text-red-500">No Receipt</span>
              <?php endif; ?>
            </td>
            <td class="border p-2">
              <button 
                onclick="approveRecharge(<?= (int)$r['id'] ?>)" 
                class="bg-green-500 text-white px-3 py-1 rounded hover:bg-green-600">
                Approve
              </button>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>

    <?php if (empty($recharges)): ?>
      <p class="text-gray-500 text-center mt-6">No pending recharges.</p>
    <?php endif; ?>
  </div>

<script>
function approveRecharge(id) {
    Swal.fire({
        title: 'Approve this recharge?',
        text: "The amount will be credited to the user's wallet.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, approve it!'
    }).then((result) => {
        if (result.isConfirmed) {
            // Redirect to your approve page
            window.location.href = 'approve_recharge.php?id=' + id;
        }
    });
}
</script>

</body>
</html>