<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();

if (empty($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}

include 'admin_db.php';

// Handle approve/reject actions
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $record_id = intval($_POST['record_id']);
    $action = $_POST['action'];

    // Fetch the pending recharge record
    $stmt = $conn->prepare("SELECT * FROM recharge_records WHERE id = ? AND status = 'pending'");
    $stmt->execute([$record_id]);
    $record = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($record) {
        if ($action === 'approve') {
            // Mark as success
            $conn->prepare("UPDATE recharge_records SET status='success' WHERE id=?")->execute([$record_id]);
            // Credit user wallet
            $conn->prepare("UPDATE users SET electronic_wallet = electronic_wallet + ? WHERE phone=?")
                 ->execute([$record['amount'], $record['phone']]);
        } elseif ($action === 'reject') {
            $conn->prepare("UPDATE recharge_records SET status='rejected' WHERE id=?")->execute([$record_id]);
        }
    }
}

// Fetch all pending deposits
$stmt = $conn->prepare("
    SELECT r.*
    FROM recharge_records r
    WHERE r.status='pending'
    ORDER BY r.id DESC
");
$stmt->execute();
$deposits = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin - Pending Deposits</title>
<script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-white font-sans p-6">

<h1 class="text-2xl font-bold mb-6 text-yellow-400">Pending Deposits</h1>

<table class="min-w-full bg-gray-800 rounded-lg overflow-hidden">
<thead>
<tr class="bg-yellow-500 text-gray-900">
    <th class="py-2 px-4">#</th>
    <th class="py-2 px-4">Name (Typed)</th>
    <th class="py-2 px-4">Phone</th>
    <th class="py-2 px-4">Amount</th>
    <th class="py-2 px-4">Payment Method</th>
    <th class="py-2 px-4">Account / Bank</th>
    <th class="py-2 px-4">Transaction / Notes</th>
    <th class="py-2 px-4">Date</th>
    <th class="py-2 px-4">Action</th>
</tr>
</thead>
<tbody>
<?php foreach($deposits as $index => $d): ?>
<tr class="border-b border-gray-700">
    <td class="py-2 px-4"><?= $index+1 ?></td>
    <td class="py-2 px-4"><?= htmlspecialchars($d['name'] ?? '-') ?></td>
    <td class="py-2 px-4"><?= htmlspecialchars($d['phone'] ?? '-') ?></td>
    <td class="py-2 px-4">₦<?= number_format($d['amount'] ?? 0, 2) ?></td>
    <td class="py-2 px-4"><?= htmlspecialchars($d['payment_method'] ?? '-') ?></td>
    <td class="py-2 px-4">
        <?= htmlspecialchars($d['bank_name'] ?? '-') ?><br>
        <?= htmlspecialchars($d['account_number'] ?? '-') ?>
    </td>
    <td class="py-2 px-4">
        <?= htmlspecialchars($d['transaction_id'] ?? '-') ?><br>
        <?= htmlspecialchars($d['notes'] ?? '-') ?>
    </td>
    <td class="py-2 px-4"><?= !empty($d['created_at']) ? date('m/d/Y H:i', strtotime($d['created_at'])) : '-' ?></td>
    <td class="py-2 px-4 flex gap-2">
        <form method="POST" style="display:inline;">
            <input type="hidden" name="record_id" value="<?= $d['id'] ?>">
            <button name="action" value="approve" class="bg-green-500 hover:bg-green-600 text-gray-900 font-bold py-1 px-3 rounded">Approve</button>
        </form>
        <form method="POST" style="display:inline;">
            <input type="hidden" name="record_id" value="<?= $d['id'] ?>">
            <button name="action" value="reject" class="bg-red-500 hover:bg-red-600 text-gray-900 font-bold py-1 px-3 rounded">Reject</button>
        </form>
    </td>
</tr>
<?php endforeach; ?>
<?php if(empty($deposits)): ?>
<tr>
    <td colspan="9" class="py-4 px-4 text-center text-gray-400">No pending deposits</td>
</tr>
<?php endif; ?>
</tbody>
</table>

</body>
</html>