<?php
require './auth/admin/admin_db.php';

if (!isset($_GET['id'])) {
  echo "Video ID not found.";
  exit;
}

$video_id = $_GET['id'];
$stmt = $conn->prepare("SELECT * FROM videos WHERE id = ?");
$stmt->execute([$video_id]);
$video = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$video) {
  echo "Video not found.";
  exit;
}

// Extract YouTube video ID
parse_str(parse_url($video['youtube_link'], PHP_URL_QUERY), $yt_params);
$yt_id = $yt_params['v'] ?? '';
?>

<!DOCTYPE html>
<html>
<head>
  <title><?= htmlspecialchars($video['title']) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      margin: 0;
      padding: 10px;
      background: #000;
      color: white;
      font-family: Arial, sans-serif;
    }
    .video-container {
      position: relative;
      padding-top: 56.25%;
      height: 0;
      overflow: hidden;
      border-radius: 10px;
    }
    .video-container iframe {
      position: absolute;
      top: 0; left: 0;
      width: 100%; height: 100%;
    }
    .score-btn {
      background: #28a745;
      color: white;
      padding: 15px;
      border: none;
      width: 100%;
      font-size: 18px;
      border-radius: 10px;
      margin-top: 20px;
      cursor: pointer;
    }
  </style>
</head>
<body>

<h2><?= htmlspecialchars($video['title']) ?></h2>

<div class="video-container">
  <iframe src="https://www.youtube.com/embed/<?= $yt_id ?>" frameborder="0" allowfullscreen></iframe>
</div>

<button class="score-btn">Score to get income</button>

</body>
</html>