<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
include 'db.php';

if (!isset($_SESSION['phone'])) {
  header("Location: login.php");
  exit();
}

$phone = $_SESSION['phone'];
$email = $_SESSION['email'] ?? ''; 
$success = "";
$error = "";
$boundWallets = [];

// --- SEND OTP (AJAX call triggers this section) ---
if (isset($_POST['action']) && $_POST['action'] === 'send_otp') {
    $email = $_POST['email'] ?? '';
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid email address.']);
        exit;
    }

    $otp = rand(100000, 999999);
    $_SESSION['email_otp'] = $otp;
    $_SESSION['otp_expires'] = time() + 300; // 5 minutes validity

    $subject = "Your New-Line-Cinema Verification Code";
    $message = "Your verification code is: $otp\nThis code expires in 5 minutes.";
    $headers = "From: no-reply@new-line-cinema.cc";

    if (mail($email, $subject, $message, $headers)) {
        echo json_encode(['status' => 'success', 'message' => 'Verification code sent successfully.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to send verification email.']);
    }
    exit;
}

// --- FORM SUBMISSION ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && empty($_POST['action'])) {
    $currency = $_POST['currency'];
    $network = $_POST['network'];
    $address = $_POST['address'];
    $otp = $_POST['otp'];
    $email_input = $_POST['email'];

    if (!isset($_SESSION['email_otp'])) {
        $error = "Please request a verification code first.";
    } elseif (time() > ($_SESSION['otp_expires'] ?? 0)) {
        $error = "Verification code expired.";
    } elseif ($otp == $_SESSION['email_otp']) {
        $insert = $conn->prepare("INSERT INTO wallets (phone, currency, network, address) VALUES (?, ?, ?, ?)");
        if ($insert->execute([$phone, $currency, $network, $address])) {
            $success = "Wallet bound successfully!";
            unset($_SESSION['email_otp']);
        } else {
            $error = "Failed to save wallet. Try again.";
        }
    } else {
        $error = "Invalid verification code.";
    }
}

// --- FETCH WALLETS FOR DISPLAY ---
$stmt = $conn->prepare("SELECT currency, network, address FROM wallets WHERE phone = ?");
$stmt->execute([$phone]);
$boundWallets = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
  <title>Binding Address</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      background: #000;
      color: #fff;
      font-family: 'Poppins', sans-serif;
      margin: 0;
      padding: 20px;
    }
    .topbar {
      display: flex;
      align-items: center;
      justify-content: space-between;
      font-size: 18px;
      margin-bottom: 20px;
    }
    .topbar a {
      color: #fff;
      text-decoration: none;
      font-size: 22px;
    }
    .section {
      background: #111;
      border-radius: 12px;
      padding: 20px;
      margin-bottom: 25px;
    }
    label {
      display: block;
      color: #aaa;
      font-size: 14px;
      margin-top: 15px;
    }
    input[type="text"], .select-box {
      width: 100%;
      padding: 12px;
      margin-top: 5px;
      border-radius: 10px;
      border: 1px solid #333;
      background: #222;
      color: #fff;
      font-size: 15px;
      box-sizing: border-box;
      cursor: pointer;
    }
    .row {
      display: flex;
      justify-content: space-between;
      gap: 10px;
    }
    .otp-group {
      display: flex;
      align-items: center;
      gap: 10px;
    }
    .otp-group input {
      flex: 1;
    }
    .send-btn {
      background: transparent;
      border: none;
      color: #f8d46e;
      font-weight: bold;
      cursor: pointer;
      font-size: 14px;
    }
    button.submit {
      width: 100%;
      padding: 14px;
      margin-top: 25px;
      border: none;
      border-radius: 30px;
      background: linear-gradient(180deg, #FFD08A 0%, #D9A85C 100%);
      color: #000;
      font-size: 16px;
      font-weight: bold;
      cursor: pointer;
    }
    /* Toast */
    #toast {
      visibility: hidden;
      min-width: 250px;
      background: rgba(20,20,20,0.9);
      color: #fff;
      text-align: center;
      border-radius: 8px;
      padding: 12px;
      position: fixed;
      bottom: 30px;
      left: 50%;
      transform: translateX(-50%);
      z-index: 9999;
      font-size: 14px;
      opacity: 0;
      transition: opacity 0.5s, bottom 0.5s;
    }
    #toast.show {
      visibility: visible;
      opacity: 1;
      bottom: 50px;
    }
    #toast.success { border-left: 5px solid #4caf50; box-shadow: 0 0 10px #4caf50; }
    #toast.error { border-left: 5px solid #ff5252; box-shadow: 0 0 10px #ff5252; }

    /* Wallet list */
    .wallet-list {
      background: #111;
      border-radius: 12px;
      padding: 15px;
    }
    .wallet-item {
      border-bottom: 1px solid #222;
      padding: 10px 0;
    }
    .wallet-item:last-child { border: none; }
    .wallet-item span {
      display: block;
      color: #f8d46e;
      font-size: 13px;
      margin-top: 4px;
      word-break: break-all;
    }

    /* Modal */
    .modal {
      position: fixed;
      bottom: -100%;
      left: 0;
      width: 100%;
      background: #111;
      border-radius: 16px 16px 0 0;
      transition: bottom 0.3s ease-in-out;
      z-index: 1000;
      padding: 20px;
    }
    .modal.active { bottom: 0; }
    .modal h3 {
      text-align: center;
      color: #fff;
      margin-bottom: 15px;
      font-weight: 600;
    }
    .modal-option {
      padding: 14px;
      border-bottom: 1px solid #222;
      text-align: center;
      cursor: pointer;
      color: #f8d46e;
    }
    .modal-option:hover { background: #222; }
  </style>
</head>
<body>

<div class="topbar">
  <a href="withdraw.php">←</a>
  <span>Binding Address</span>
  <div></div>
</div>

<div class="section">
  <form method="post">
    <div class="row">
      <div>
        <label>Recharge Channel</label>
        <div class="select-box" onclick="openModal('currencyModal')" id="currencyDisplay">USDT</div>
        <input type="hidden" name="currency" id="currencyInput" value="USDT">
      </div>
      <div>
        <label>Mainnet</label>
        <div class="select-box" onclick="openModal('networkModal')" id="networkDisplay">TRC20</div>
        <input type="hidden" name="network" id="networkInput" value="TRC20">
      </div>
    </div>

    <label>Address</label>
    <input type="text" name="address" placeholder="Please enter the address" required>

    <label>Email</label>
    <div class="otp-group">
      <input type="text" name="email" placeholder="Please enter your email" value="<?= htmlspecialchars($email) ?>" required>
      <button type="button" class="send-btn" onclick="sendOTP()">Send</button>
    </div>

    <label>Email verification code</label>
    <input type="text" name="otp" placeholder="Please enter the email verification code" required>

    <button type="submit" class="submit">OK</button>
  </form>
</div>

<?php if (!empty($boundWallets)): ?>
<div class="wallet-list">
  <h3 style="color:#f8d46e;text-align:center;margin-bottom:10px;">Bound Wallets</h3>
  <?php foreach ($boundWallets as $w): ?>
  <div class="wallet-item">
    <?= htmlspecialchars($w['currency']) ?> (<?= htmlspecialchars($w['network']) ?>)
    <span><?= htmlspecialchars($w['address']) ?></span>
  </div>
  <?php endforeach; ?>
</div>
<?php endif; ?>

<div id="toast"></div>

<!-- Modals -->
<div id="currencyModal" class="modal">
  <h3>Select Channel</h3>
  <div class="modal-option" onclick="selectOption('currency', 'USDT')">USDT</div>
  <div class="modal-option" onclick="selectOption('currency', 'BTC')">BTC</div>
  <div class="modal-option" onclick="selectOption('currency', 'ETH')">ETH</div>
</div>

<div id="networkModal" class="modal">
  <h3>Select Network</h3>
  <div class="modal-option" onclick="selectOption('network', 'TRC20')">TRC20</div>
  <div class="modal-option" onclick="selectOption('network', 'ERC20')">ERC20</div>
  <div class="modal-option" onclick="selectOption('network', 'BEP20')">BEP20</div>
</div>

<script>
function showToast(message, type='success') {
  const toast = document.getElementById('toast');
  toast.textContent = message;
  toast.className = `show ${type}`;
  setTimeout(() => toast.classList.remove('show'), 3000);
}

function openModal(id) {
  document.getElementById(id).classList.add('active');
}

window.addEventListener('click', function(e) {
  if (e.target.classList.contains('modal')) e.target.classList.remove('active');
});

function selectOption(type, value) {
  if (type === 'currency') {
    document.getElementById('currencyDisplay').textContent = value;
    document.getElementById('currencyInput').value = value;
    document.getElementById('currencyModal').classList.remove('active');
  } else {
    document.getElementById('networkDisplay').textContent = value;
    document.getElementById('networkInput').value = value;
    document.getElementById('networkModal').classList.remove('active');
  }
}

function sendOTP() {
  const email = document.querySelector('input[name="email"]').value.trim();
  if (!email) {
    showToast("Please enter your email first.", "error");
    return;
  }
  fetch("", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: new URLSearchParams({ action: "send_otp", email })
  })
  .then(res => res.json())
  .then(data => showToast(data.message, data.status))
  .catch(() => showToast("Failed to send verification code.", "error"));
}

<?php if ($success): ?>
  showToast("<?= addslashes($success) ?>", "success");
  setTimeout(() => { window.location.href = "withdraw.php"; }, 2000);
<?php elseif ($error): ?>
  showToast("<?= addslashes($error) ?>", "error");
<?php endif; ?>
</script>

</body>
</html>