<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
include 'db.php';

if (!isset($_SESSION['phone'])) {
    header("Location: login.php");
    exit();
}

$phone = $_SESSION['phone'];

// Fetch user
$stmt = $conn->prepare("SELECT full_name FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $full_name = trim($_POST['full_name']);

    if (!empty($full_name)) {
        $update = $conn->prepare("UPDATE users SET full_name = ? WHERE phone = ?");
        $update->execute([$full_name, $phone]);
        $user['full_name'] = $full_name;
        $message = "Name saved successfully!";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Verify Identity</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background: #000;
      color: #fff;
    }

    .top-bar {
      display: flex;
      align-items: center;
      justify-content: center;
      height: 50px;
      background-color: #111;
      border-bottom: 1px solid #333;
      position: relative;
    }

    .back-arrow {
      position: absolute;
      left: 10px;
      font-size: 22px;
      cursor: pointer;
      color: white;
      line-height: 50px;
    }

    .title {
      font-size: 18px;
      font-weight: bold;
    }

    .content {
      padding: 70px 20px 20px;
      text-align: center;
    }

    input[type="text"] {
      padding: 10px;
      width: 80%;
      border: none;
      border-radius: 5px;
      margin-top: 20px;
    }

    button {
      margin-top: 20px;
      padding: 10px 20px;
      background: #28a745;
      border: none;
      border-radius: 5px;
      color: white;
      font-weight: bold;
    }

    .message {
      margin-top: 10px;
      color: #0f0;
    }
  </style>
</head>
<body>

  <div class="top-bar">
    <div class="back-arrow" onclick="history.back()">←</div>
    <div class="title">Full Name</div>
  </div>

  <div class="content">
    <?php if (!empty($user['full_name'])): ?>
      <h3>Your Name: <?= htmlspecialchars($user['full_name']) ?></h3>
    <?php else: ?>
      <form method="post">
        <input type="text" name="full_name" placeholder="Enter your full name" required><br>
        <button type="submit">Submit</button>
      </form>
    <?php endif; ?>

    <?php if (!empty($message)): ?>
      <div class="message"><?= $message ?></div>
    <?php endif; ?>
  </div>

</body>
</html>