<?php
session_start();
include 'db.php';

if (!isset($_SESSION['phone'])) {
  header("Location: login.php");
  exit();
}

$phone = $_SESSION['phone'];
$response = '';

// ✅ Fetch existing verification data
$stmt = $conn->prepare("SELECT verify_method, verify_contact FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
$verify_method = $user['verify_method'] ?? '';
$verify_contact = $user['verify_contact'] ?? '';

// ✅ Handle new verification if not already bound
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !$verify_method && !$verify_contact) {
  $method = $_POST['method'] ?? '';
  $contact = trim($_POST['contact'] ?? '');

  if ($method && $contact) {
    if ($method === 'Whatsapp' && !preg_match('/^\+?\d{10,15}$/', $contact)) {
      $response = "invalid_whatsapp";
    } elseif ($method === 'Telegram' && !preg_match('/^@[A-Za-z0-9_]{5,32}$/', $contact)) {
      $response = "invalid_telegram";
    } else {
      $stmt = $conn->prepare("UPDATE users SET verify_method = ?, verify_contact = ? WHERE phone = ?");
      $stmt->execute([$method, $contact, $phone]);
      $response = "success";
      $verify_method = $method;
      $verify_contact = $contact;
    }
  } else {
    $response = "empty";
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport"
  content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<title>Official Verification</title>
<style>
  body {
    margin: 0;
    padding: 0;
    height: 100%;
    background: #000;
    color: #fff;
    font-family: 'Poppins', sans-serif;
    overflow: hidden;
  }

  .header {
    background: #000;
    text-align: center;
    font-size: 1.1rem;
    font-weight: 600;
    padding: 18px;
    border-bottom: 1px solid #1a1a1a;
    position: fixed;
    top: 0; left: 0; right: 0;
    z-index: 10;
  }

  .container {
    max-width: 450px;
    margin: 90px auto 0;
    padding: 0 20px;
  }

  label {
    display: block;
    font-size: 0.9rem;
    color: #b3b3b3;
    margin-bottom: 6px;
  }

  .select-box, input, .btn {
    width: 100%;
    height: 54px;
    border-radius: 12px;
    font-size: 1rem;
    margin-bottom: 18px;
    padding: 0 14px;
    box-sizing: border-box;
  }

  input {
    background: #121212;
    border: 1px solid #444;
    color: #fff;
  }

  input::placeholder { color: #666; }

  input[readonly] {
    background: #1b1b1b;
    border-color: #333;
    color: #777;
    cursor: not-allowed;
  }

  .select-box {
    background: #121212;
    border: 1px solid #444;
    display: flex;
    justify-content: space-between;
    align-items: center;
    cursor: pointer;
  }

  .select-box span { color: #ccc; }

  .select-box::after {
    content: '›';
    font-size: 1.4rem;
    color: #888;
  }

  .btn {
    background: #00ff33;
    border: none;
    color: #000;
    font-weight: 600;
    cursor: pointer;
    transition: 0.2s;
  }

  .btn:disabled {
    background: #222;
    color: #555;
    cursor: not-allowed;
  }

  .btn:hover:not(:disabled) {
    opacity: 0.9;
  }

  .tips {
    background: rgba(255, 215, 0, 0.06);
    border-left: 3px solid #f0b43c;
    padding: 15px;
    border-radius: 6px;
    margin-top: 30px;
    font-size: 0.85rem;
    color: #ccc;
  }

  .tips b { color: #f0b43c; }

  /* Bottom modal */
  .bottom-modal {
    position: fixed;
    left: 0; right: 0;
    bottom: -100%;
    background: #000;
    border-top-left-radius: 18px;
    border-top-right-radius: 18px;
    box-shadow: 0 -2px 20px rgba(0,0,0,0.6);
    transition: all 0.3s ease;
    z-index: 100;
    text-align: center;
    padding: 20px;
  }

  .bottom-modal.show { bottom: 0; }

  .modal-title {
    color: #ccc;
    font-weight: 600;
    margin-bottom: 15px;
  }

  .modal-option {
    background: #111;
    border: 1px solid #333;
    border-radius: 10px;
    padding: 14px;
    font-size: 1rem;
    margin: 10px 0;
    cursor: pointer;
    color: #fff;
    transition: 0.2s;
  }

  .modal-option:hover {
    border-color: #f0b43c;
    color: #f0b43c;
  }

  .modal-cancel {
    color: #888;
    margin-top: 15px;
    cursor: pointer;
  }

  /* Notification box */
  .notify-box {
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background: rgba(20, 20, 20, 0.95);
    border: 1px solid #f0b43c;
    border-radius: 12px;
    padding: 20px;
    color: #f0b43c;
    font-weight: 500;
    text-align: center;
    display: none;
    z-index: 999;
    animation: fadeIn 0.3s ease;
  }

  @keyframes fadeIn {
    from { opacity: 0; transform: translate(-50%, -60%); }
    to { opacity: 1; transform: translate(-50%, -50%); }
  }
</style>
</head>
<body>

<div class="header">Official Verification</div>

<div class="container">
  <form method="POST">
    <label>Verification Method</label>
    <div class="select-box"
      onclick="<?php echo (!$verify_method && !$verify_contact) ? 'openModal()' : ''; ?>">
      <span id="methodText">
        <?php echo $verify_method ? htmlspecialchars($verify_method) : 'Select Method'; ?>
      </span>
    </div>
    <input type="hidden" name="method" id="methodInput"
      value="<?php echo htmlspecialchars($verify_method); ?>">

    <label>Enter Contact</label>
    <input type="text" name="contact" id="contact"
      value="<?php echo htmlspecialchars($verify_contact); ?>"
      placeholder="Enter Telegram username or WhatsApp number"
      <?php echo ($verify_contact) ? 'readonly' : ''; ?> required>

    <button type="submit" class="btn"
      <?php echo ($verify_contact) ? 'disabled' : ''; ?>>OK</button>
  </form>

  <div class="tips">
    <b>⚠️ Kind Tips:</b><br>
    Once your contact is verified, it cannot be changed again for your account safety.
  </div>
</div>

<!-- Bottom modal -->
<div class="bottom-modal" id="bottomModal">
  <div class="modal-title">Select Verification Method</div>
  <div class="modal-option" onclick="selectMethod('Telegram')">Telegram</div>
  <div class="modal-option" onclick="selectMethod('Whatsapp')">Whatsapp</div>
  <div class="modal-cancel" onclick="closeModal()">Cancel</div>
</div>

<!-- Notification -->
<div class="notify-box" id="notifyBox"></div>

<script>
const modal = document.getElementById('bottomModal');
const methodText = document.getElementById('methodText');
const methodInput = document.getElementById('methodInput');
const notifyBox = document.getElementById('notifyBox');

function openModal() {
  modal.classList.add('show');
}

function closeModal() {
  modal.classList.remove('show');
}

function selectMethod(method) {
  methodText.textContent = method;
  methodInput.value = method;
  closeModal();
}

function showNotify(message) {
  notifyBox.innerHTML = message;
  notifyBox.style.display = 'block';
  setTimeout(() => notifyBox.style.display = 'none', 3000);
}

// ✅ Show feedback messages
<?php if ($response === 'success'): ?>
  showNotify('✅ Verification saved successfully!');
<?php elseif ($response === 'invalid_whatsapp'): ?>
  showNotify('⚠️ Enter a valid WhatsApp number (e.g. +2348012345678)');
<?php elseif ($response === 'invalid_telegram'): ?>
  showNotify('⚠️ Enter a valid Telegram username (e.g. @username)');
<?php elseif ($response === 'empty'): ?>
  showNotify('⚠️ Please select a method and enter your contact.');
<?php endif; ?>
</script>

</body>
</html>