<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include __DIR__ . '/../../db.php';

$toast_message = "";
$toast_type = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username       = trim($_POST['username'] ?? "");
    $email          = trim($_POST['email'] ?? "");
    $country_code   = trim($_POST['country_code'] ?? "");
    $phone          = trim($_POST['phone'] ?? "");
    $password       = trim($_POST['password'] ?? "");
    $confirm        = trim($_POST['confirm_password'] ?? "");
    $invite         = trim($_POST['invite_code'] ?? "");
    $agree          = isset($_POST['agree']);

    if (!$username || !$email || !$country_code || !$phone || !$password || !$confirm || !$agree) {
        $toast_message = "Please fill all fields and agree to the policy.";
        $toast_type = "error";
    } elseif ($password !== $confirm) {
        $toast_message = "Passwords do not match.";
        $toast_type = "error";
    } else {
        $full_phone     = $country_code . $phone;
        $hashed         = password_hash($password, PASSWORD_DEFAULT);
        $my_invite_code = substr(str_shuffle('ABCDEFGHJKLMNPQRSTUVWXYZ23456789'), 0, 6);

        // Check if username or email or phone already exists
        $check = $conn->prepare("SELECT COUNT(*) FROM users WHERE username = ? OR email = ? OR phone = ?");
        $check->execute([$username, $email, $full_phone]);
        if ($check->fetchColumn() > 0) {
            $toast_message = "Username, email, or phone already exists.";
            $toast_type = "error";
        } else {
            $stmt = $conn->prepare("
                INSERT INTO users (username, email, phone, password, invite_code, invited_by, created_at)
                VALUES (?, ?, ?, ?, ?, ?, NOW())
            ");
            if ($stmt->execute([$username, $email, $full_phone, $hashed, $my_invite_code, $invite])) {
                $toast_message = "Registration successful!";
                $toast_type = "success";
            } else {
                $toast_message = "Registration failed. Please try again.";
                $toast_type = "error";
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<title>Register</title>
<style>
/* --- Body & Zoom Lock --- */
html, body {
  margin: 0; padding: 0;
  font-family: "Poppins", sans-serif;
  background-color: #000; color: #fff;
  touch-action: pan-x pan-y; overscroll-behavior: none;
  -ms-content-zooming: none; -ms-touch-action: pan-x pan-y;
  -webkit-text-size-adjust: 100%; text-size-adjust: 100%;
}

/* --- Toast --- */
.toast {
  position: fixed;
  top: 50%; left: 50%;
  transform: translate(-50%, -50%);
  background: rgba(0,0,0,0.85);
  color: #fff;
  padding: 12px 20px;
  border-radius: 10px;
  font-size: 14px;
  z-index: 2000;
  opacity: 0;
  transition: opacity 0.3s ease;
}
.toast.show { opacity: 1; }

/* --- Form container & other styles remain same --- */
.header-image { width: 100%; height: 220px; background: url('/../../back.jpg') center/cover no-repeat; }
.form-container { background: #111; border-radius: 25px 25px 0 0; padding: 30px 25px 60px; margin-top: -30px; position: relative; z-index: 2; box-shadow: 0 -4px 12px rgba(0, 0, 0, 0.4); }
form { display: flex; flex-direction: column; gap: 15px; }
h2 { text-align: center; font-size: 22px; font-weight: 600; margin-bottom: 20px; }
.username-box,.email-box,.password-box,.confirm-box,.invite-box { height: 40px; font-size: 14px; padding:0 10px; border-radius:10px; background:#2a2a2a; color:#fff; border:1.5px solid #000; box-shadow:0 2px 6px rgba(255,255,255,0.1); }
.username-box::placeholder,.email-box::placeholder,.password-box::placeholder,.confirm-box::placeholder,.invite-box::placeholder { color:#ccc; }
.phone-wrapper { display:flex; align-items:center; background:#2c2c2c; border-radius:10px; overflow:hidden; border:1.5px solid #000; box-shadow: inset 0 1px 3px rgba(255,255,255,0.1),0 2px 6px rgba(0,0,0,0.4); }
.phone-wrapper button { height:40px; font-size:14px; background:#2c2c2c; border:none; color:#fff; border-right:1px solid #555; padding:0 12px; margin-right:5px; }
.phone-wrapper input { flex:1; height:40px; font-size:14px; padding:0 10px; border:none; background:#2c2c2c; color:#fff; }
.register-button { width:100%; height:40px; border:none; border-radius:12px; background:linear-gradient(to right,#ffddb3,#ffc685); color:#111; font-weight:400; font-size:15px; cursor:pointer; margin-top:5px; transition:opacity 0.3s ease; }
.register-button:hover { opacity:0.9; }
.checkbox-text { font-size:13px; line-height:1.5; } .checkbox-text label { display:flex; align-items:center; gap:8px; } .checkbox-text input[type="checkbox"] { width:18px; height:18px; accent-color:#f9b44c; } .checkbox-text a { color:#f9b44c; text-decoration:none; }
.bottom-text { text-align:center; font-size:14px; margin-top:15px; } .bottom-text a { color:#f9b44c; text-decoration:none; font-weight:500; }
.country-modal { position:fixed; left:0; right:0; bottom:-100%; background:#1a1a1a; border-radius:20px 20px 0 0; color:#fff; padding:20px; height:50vh; transition:bottom 0.3s ease; z-index:1000; }
.country-modal.show { bottom:0; } .country-modal h3 { text-align:center; margin-bottom:15px; color:#f9b44c; }
.country-option { padding:12px 0; border-bottom:1px solid #333; cursor:pointer; text-align:center; font-size:16px; }
.country-option:hover { background:#222; }
</style>
</head>
<body>

<div class="header-image"></div>

<div class="form-container">
  <h2>Register</h2>
  <form method="POST" autocomplete="off" autocorrect="off" autocapitalize="none" spellcheck="false">
    <input type="text" name="username" class="username-box" placeholder="Enter username" required autocomplete="off" autocorrect="off" autocapitalize="none" spellcheck="false">
    <input type="email" name="email" class="email-box" placeholder="Enter email address" required autocomplete="off" autocorrect="off" autocapitalize="none" spellcheck="false">

    <div class="phone-wrapper">
      <button type="button" id="countryBtn">+44</button>
      <input type="hidden" name="country_code" id="country_code" value="+234">
      <input type="text" name="phone" placeholder="Enter phone number" required autocomplete="off" autocorrect="off" autocapitalize="none" spellcheck="false">
    </div>

    <input type="password" name="password" class="password-box" placeholder="Login password" required autocomplete="new-password" autocorrect="off" autocapitalize="none" spellcheck="false">
    <input type="password" name="confirm_password" class="confirm-box" placeholder="Confirm password" required autocomplete="new-password" autocorrect="off" autocapitalize="none" spellcheck="false">
    <input type="text" name="invite_code" class="invite-box" id="invite_code" placeholder="Invitation code" required autocomplete="off" autocorrect="off" autocapitalize="none" spellcheck="false">
    
    <div class="checkbox-text">
      <label><input type="checkbox" name="agree" required> I agree to the <a href="#">User Agreement</a> & <a href="#">Privacy Policy</a></label>
    </div>
    <button type="submit" class="register-button">Register Now</button>
    <div class="bottom-text">Already have an account? <a href="login.php">Login now</a></div>
  </form>
</div>

<div class="country-modal" id="countryModal">
  <h3>Select Country Code</h3>
  <div class="country-option" data-code="+234">🇳🇬 +234 Nigeria</div>
  <div class="country-option" data-code="+1">🇺🇸 +1 United States</div>
  <div class="country-option" data-code="+44">🇬🇧 +44 United Kingdom</div>
  <div class="country-option" data-code="+91">🇮🇳 +91 India</div>
</div>

<div class="toast" id="toast"></div>

<script>
// Country selection modal
const modal = document.getElementById('countryModal');
const btn = document.getElementById('countryBtn');
const input = document.getElementById('country_code');

btn.onclick = () => modal.classList.add('show');

document.querySelectorAll('.country-option').forEach(opt => {
  opt.addEventListener('click', () => {
    const code = opt.getAttribute('data-code');
    btn.innerText = code;
    input.value = code;
    modal.classList.remove('show');
  });
});

window.addEventListener('click', (e) => {
  if (e.target === modal) modal.classList.remove('show');
});

// Fill invitation code from URL if available
const urlParams = new URLSearchParams(window.location.search);
const inviteCode = urlParams.get('inviteCode'); // e.g., ?inviteCode=ABC123
if (inviteCode) {
  const inviteInput = document.getElementById('invite_code');
  inviteInput.value = inviteCode;
  // Optional: make it readonly so users can't modify it
  inviteInput.readOnly = true;
}

// Toast function
function showToast(message) {
  const toast = document.getElementById("toast");
  toast.innerText = message;
  toast.classList.add("show");
  setTimeout(() => toast.classList.remove("show"), 2500);
}

// Display PHP toast and redirect
<?php if($toast_message): ?>
  showToast("<?= addslashes($toast_message) ?>");
  <?php if($toast_type === "success"): ?>
    setTimeout(()=>{ window.location.href='login.php'; }, 2500);
  <?php endif; ?>
<?php endif; ?>
</script>
</body>
</html>