<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Generate random captcha text
$captcha_code = substr(str_shuffle("ABCDEFGHJKLMNPQRSTUVWXYZ23456789"), 0, 5);
$_SESSION['captcha'] = $captcha_code;

// Create image
$width = 120;
$height = 40;
$image = imagecreate($width, $height);

// Colors
$background_color = imagecolorallocate($image, 255, 255, 255); 
$text_color = imagecolorallocate($image, 0, 0, 0);
$line_color = imagecolorallocate($image, 64, 64, 64);
$pixel_color = imagecolorallocate($image, 100, 100, 100);

// Add random lines
for ($i = 0; $i < 3; $i++) {
    imageline($image, 0, rand() % $height, $width, rand() % $height, $line_color);
}

// Add random dots
for ($i = 0; $i < 500; $i++) {
    imagesetpixel($image, rand() % $width, rand() % $height, $pixel_color);
}

// Add text
$font_size = 5;
imagestring($image, $font_size, 30, 10, $captcha_code, $text_color);

// Output captcha
header("Content-type: image/png");
imagepng($image);
imagedestroy($image);
?>