<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
include 'db.php';

// Only handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = $_POST['title'];
    $video_id = $_POST['video_id'];
    $earning = $_POST['earning'];
    $vip_id = $_POST['vip_id'];

    // Build YouTube embed and thumbnail URLs
    $video_url = "https://www.youtube.com/embed/" . $video_id;
    $thumbnail = "https://img.youtube.com/vi/" . $video_id . "/0.jpg";

    // Insert into videos table
    $stmt = $conn->prepare("INSERT INTO videos (vip_id, title, video_url, thumbnail, earning) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$vip_id, $title, $video_url, $thumbnail, $earning]);

    echo "<p style='color:green;'>✅ Video uploaded successfully!</p>";
}
?>

<!-- HTML Form -->
<h2>Upload a New Video</h2>
<form method="POST" action="upload_video.php">
    <label>Video Title:</label><br>
    <input type="text" name="title" required><br><br>

    <label>YouTube Video ID:</label><br>
    <input type="text" name="video_id" required placeholder="Example: dQw4w9WgXcQ"><br><br>

    <label>Earning Amount ($):</label><br>
    <input type="number" step="0.01" name="earning" required><br><br>

    <label>VIP Level:</label><br>
    <select name="vip_id" required>
        <option value="0">VIP 0 (Free)</option>
        <option value="1">VIP 1</option>
        <option value="2">VIP 2</option>
        <option value="3">VIP 3</option>
        <!-- Add more if needed -->
    </select><br><br>

    <button type="submit">Upload Video</button>
</form>