<?php
session_start();
include 'db.php';
header('Content-Type: application/json');

if (!isset($_SESSION['phone'])) {
  echo json_encode(['status' => 'error', 'message' => 'Not logged in']);
  exit;
}

$phone = $_SESSION['phone'];
$stmt = $conn->prepare("SELECT id FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user_id = $stmt->fetchColumn();

if (!$user_id) {
  echo json_encode(['status' => 'error', 'message' => 'User not found']);
  exit;
}

if (!isset($_POST['vip_id'])) {
  echo json_encode(['status' => 'error', 'message' => 'Missing VIP ID']);
  exit;
}

$vip_id = (int)$_POST['vip_id'];

// 🔹 Decrease valid days by 1 (reduce expire_at)
$stmt = $conn->prepare("
  UPDATE purchases 
  SET expire_at = DATE_SUB(expire_at, INTERVAL 1 DAY)
  WHERE user_id = ? AND vip_product_id = ? AND expire_at > NOW()
");
$stmt->execute([$user_id, $vip_id]);

if ($stmt->rowCount() > 0) {
  echo json_encode(['status' => 'success']);
} else {
  echo json_encode(['status' => 'error', 'message' => 'No active VIP found or already expired']);
}
?>