
<?php  
ini_set('display_errors', 1);  
ini_set('display_startup_errors', 1);  
error_reporting(E_ALL);  
session_start();  
include 'db.php';  
  
if (!isset($_SESSION['phone'])) {  
  header("Location: login.php");  
  exit();  
}  
  
$phone = $_SESSION['phone'];  
  
// Get user ID + wallet balances  
$stmt = $conn->prepare("SELECT id, flexible_wallet, electronic_wallet FROM users WHERE phone = ?");  
$stmt->execute([$phone]);  
$user = $stmt->fetch(PDO::FETCH_ASSOC);  
$user_id = $user['id'];  
  
$flexible_wallet    = (float)$user['flexible_wallet'];  
$electronic_wallet  = (float)$user['electronic_wallet'];  
$total_assets       = $flexible_wallet + $electronic_wallet;  
  
// Withdrawals  
$stmt = $conn->prepare("SELECT amount, fee, status, created_at FROM withdrawals WHERE user_id = ? ORDER BY id DESC");  
$stmt->execute([$user_id]);  
$withdrawals = $stmt->fetchAll(PDO::FETCH_ASSOC);  
  
// Task Records  
$stmt = $conn->prepare("SELECT t.scored_at, t.amount, v.title   
                        FROM task_records t   
                        JOIN videos v ON t.video_id = v.id   
                        WHERE t.user_id = ?   
                        ORDER BY t.id DESC");  
$stmt->execute([$user_id]);  
$tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);  
  
// Recharge Records  
$stmt = $conn->prepare("SELECT amount, created_at, payment_method, status   
                        FROM recharge_records   
                        WHERE phone = ?   
                        ORDER BY id DESC");  
$stmt->execute([$phone]);  
$recharges = $stmt->fetchAll(PDO::FETCH_ASSOC);  
  
// Team Rebate Records  
$stmt = $conn->prepare("SELECT amount, created_at   
                        FROM rebates   
                        WHERE user_id = ?   
                        ORDER BY id DESC");  
$stmt->execute([$user_id]);  
$rebates = $stmt->fetchAll(PDO::FETCH_ASSOC);  
  
// Community Income Records  
$stmt = $conn->prepare("SELECT amount, created_at    
                        FROM assets    
                        WHERE user_id = ? AND type = 'community_income'    
                        ORDER BY id DESC");  
$stmt->execute([$user_id]);  
$community_income = $stmt->fetchAll(PDO::FETCH_ASSOC);  
  
// VIP Purchases  
$stmt = $conn->prepare("  
    SELECT v.name, p.amount, p.purchased_at AS purchase_date,  
           DATE_ADD(p.purchased_at, INTERVAL v.valid_days DAY) AS expiry_date  
    FROM purchases p  
    JOIN vip_products v ON p.vip_product_id = v.id  
    WHERE p.user_id = ?  
    ORDER BY p.id DESC  
");  
$stmt->execute([$user_id]);  
$purchases = $stmt->fetchAll(PDO::FETCH_ASSOC);  
  
// Referral Bonus  
$stmt = $conn->prepare("SELECT amount, description, created_at    
                        FROM assets    
                        WHERE user_id = ? AND type = 'referral_bonus'    
                        ORDER BY id DESC");  
$stmt->execute([$user_id]);  
$referrals = $stmt->fetchAll(PDO::FETCH_ASSOC);  
?>  <!DOCTYPE html>  <html lang="en">  
<head>  
  <meta charset="UTF-8" />  
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"/>  
  <title>Recharge and Withdraw</title>  
  <script src="https://cdn.tailwindcss.com"></script>  
  <style>  
    body {  
      background-color: #000;  
      color: #fff;  
      font-family: 'Inter', sans-serif;  
    }  
    .asset-card {  
      background: linear-gradient(to bottom, #fff8e3, #ffd78a);  
      border-radius: 18px;  
      box-shadow: 0 2px 6px rgba(0,0,0,0.2);  
    }  
    .icon-card {  
      background: #1a1a1a;  
      border-radius: 0 0 18px 18px;  
      box-shadow: 0 2px 6px rgba(0,0,0,0.3);  
      margin-top: -1rem;  
    }  
    .filter-btn {  
      background: transparent;  
      color: #fff;  
      position: relative;  
    }  
    .dropdown {  
      position: absolute;  
      top: 100%;  
      left: 0;  
      background: #1a1a1a;  
      border: 1px solid #333;  
      border-radius: 8px;  
      display: none;  
      z-index: 50;  
      min-width: 140px;  
    }  
    .dropdown.show {  
      display: block;  
    }  
    .dropdown button {  
      width: 100%;  
      padding: 0.5rem 1rem;  
      text-align: left;  
      background: transparent;  
      border: none;  
      color: #fff;  
      cursor: pointer;  
    }  
    .dropdown button:hover {  
      background: #333;  
    }  
    .filter-popup {  
      position: fixed;  
      bottom: -100%;  
      left: 0;  
      width: 100%;  
      background: #1a1a1a;  
      border-top-left-radius: 20px;  
      border-top-right-radius: 20px;  
      box-shadow: 0 -4px 12px rgba(0,0,0,0.5);  
      transition: all 0.4s ease;  
      opacity: 0;  
      z-index: 50;  
    }  
    .filter-popup.show {  
      bottom: 0;  
      opacity: 1;  
    }  
  </style>  
</head>  
<body class="min-h-screen flex flex-col">    <!-- Header -->
<div class="p-4 border-b border-gray-800 flex items-center relative">
  <button onclick="history.back()" class="text-xl absolute left-4">&#8592;</button>
  <div class="mx-auto text-lg font-semibold">Withdraw</div>
</div>
  
    <!-- Total Assets + Icon Card -->
<div class="mx-4">
  <div class="p-6 text-center asset-card text-black rounded-b-none">
    <div class="text-sm">Flexible Wallet</div> <!-- changed label -->
    <div class="text-5xl font-bold mt-2"><?= number_format($flexible_wallet,2) ?></div> <!-- show only flexible wallet -->
  </div>

  <div class="p-4 icon-card rounded-t-none">
    <div class="grid grid-cols-4 text-center text-sm text-gray-300">
      <a href="payment_method.php" class="flex flex-col items-center">
        <img src="icons/recharge.jpg" class="w-10 h-10 mb-1" />Recharge
      </a>
      <a href="withdraw.php" class="flex flex-col items-center">
        <img src="icons/withdraw.jpg" class="w-10 h-10 mb-1" />Withdraw
      </a>
      <a href="exchange.php" class="flex flex-col items-center">
        <img src="icons/transfer.jpg" class="w-10 h-10 mb-1" />Transfer
      </a>
      <a href="wallet_address.php" class="flex flex-col items-center">
        <img src="icons/address.jpg" class="w-10 h-10 mb-1" />Address
      </a>
    </div>
  </div>
</div>

  </div>    <!-- Filter Row -->    <div class="flex justify-between items-center px-4 py-2 text-sm border-b border-gray-800 relative">  
    <div class="relative">  
      <button class="filter-btn" id="activityBtn">Activity rewards ▾</button>  
      <div class="dropdown" id="activityDropdown">  
        <button data-filter="Task">Task</button>  
        <button data-filter="Team">Team</button>  
        <button data-filter="Community">Community</button>  
        <button data-filter="VIP">VIP</button>  
        <button data-filter="Referral">Referral</button>  
      </div>  
    </div>  <div class="relative">  
  <button class="filter-btn" id="allBtn">All ▾</button>  
  <div class="dropdown" id="allDropdown">  
    <button data-filter="Recharge">Recharge</button>  
    <button data-filter="Withdraw">Withdraw</button>  
    <button data-filter="Task">Task</button>  
    <button data-filter="Team">Team</button>  
    <button data-filter="Community">Community</button>  
    <button data-filter="VIP">VIP</button>  
    <button data-filter="Referral">Referral</button>  
  </div>  
</div>  

<button class="filter-btn" id="timeBtn">Select time range ▾</button>

  </div>    <!-- Records -->    <div class="flex-1 flex flex-col items-center justify-center px-4">  
    <?php if(empty($withdrawals) && empty($recharges) && empty($tasks) && empty($rebates) && empty($community_income) && empty($purchases) && empty($referrals)): ?>  
      <img src="icons/empty.png" class="w-20 opacity-70 mb-2" />  
      <div class="text-gray-400 text-sm">No data yet</div>  
    <?php else: ?>  
      <div class="w-full space-y-3 overflow-y-auto max-h-[60vh]" id="recordContainer">  
<?php   
$all_records = [  
  'Withdraw' => $withdrawals,  
  'Recharge' => $recharges,  
  'Task' => $tasks,  
  'Team' => $rebates,  
  'Community' => $community_income,  
  'VIP' => $purchases,  
  'Referral' => $referrals  
];  foreach($all_records as $type => $items):
foreach($items as $r):
$recordData = htmlspecialchars($type);
?>

<div class="bg-black/20 backdrop-blur-md border border-gray-700 p-3 rounded shadow-lg" data-record="<?= $recordData ?>">  
  <div class="flex justify-between text-sm">  
    <div>  
      <div class="font-medium">  
        <?php  
          if($type=='Task') echo 'Task: '.htmlspecialchars($r['title']??'');  
          elseif($type=='VIP') echo 'Level Purchase: '.htmlspecialchars($r['name']??''); // renamed  
          elseif($type=='Referral') echo 'Referral Bonus';  
          else echo $type;  
        ?>  
      </div>  
      <div class="text-gray-400 text-xs">  
        <?php  
          if(!empty($r['created_at'])) echo date('m/d/Y H:i:s', strtotime($r['created_at']));  
          elseif(!empty($r['purchase_date'])) echo 'Purchased: '.date('m/d/Y H:i:s', strtotime($r['purchase_date']));  
          if(!empty($r['expiry_date'])) echo '<br>Expiry: '.date('m/d/Y H:i:s', strtotime($r['expiry_date']));  
          if(!empty($r['scored_at'])) echo date('m/d/Y H:i:s', strtotime($r['scored_at']));  
          if(!empty($r['description'])) echo '<br>'.htmlspecialchars($r['description']);  
        ?>  
      </div>  
    </div>  
    <div class="text-right">  
      <div class="<?= in_array($type,['Withdraw','VIP'])?'text-yellow-400':'text-green-400' ?> font-semibold">  
        <?= in_array($type,['Withdraw','VIP'])?'-':'+' ?><?= number_format($r['amount']??0,2) ?> USDT  
      </div>  
      <div class="text-gray-400 text-xs mt-1">Completed</div> <!-- Added Completed -->  
      <?php if($type=='Withdraw'): ?>  
        <div class="text-green-500 text-xs">Status: <?= htmlspecialchars($r['status']) ?></div>  
      <?php elseif($type=='Recharge'): ?>  
        <div class="text-yellow-400 text-xs"><?= ucfirst($r['status']) ?></div>  
      <?php endif; ?>  
    </div>  
  </div>  
</div>  
<?php endforeach; endforeach; ?>  
</div>  </div>  
<?php endif; ?>

  </div>    <!-- Time Range Popup -->    <div id="filterPopup" class="filter-popup">  
    <div class="p-4 border-b border-gray-700 flex justify-between items-center">  
      <div class="text-lg font-semibold">Select time range</div>  
      <button onclick="togglePopup()" class="text-gray-400">✕</button>  
    </div>  
    <div class="p-4 space-y-3">  
      <label class="block text-sm text-gray-400">From</label>  
      <input type="date" class="w-full bg-gray-800 text-white p-2 rounded" />  
      <label class="block text-sm text-gray-400 mt-3">To</label>  
      <input type="date" class="w-full bg-gray-800 text-white p-2 rounded" />  
      <button class="w-full bg-yellow-500 text-black font-semibold py-2 rounded mt-4" onclick="togglePopup()">Apply</button>  
    </div>  
  </div>    <script>  
    const popup = document.getElementById('filterPopup');  
    const timeBtn = document.getElementById('timeBtn');  
    function togglePopup() { popup.classList.toggle('show'); }  
    timeBtn.addEventListener('click', togglePopup);  
  
    const activityBtn = document.getElementById('activityBtn');  
    const allBtn = document.getElementById('allBtn');  
    const activityDropdown = document.getElementById('activityDropdown');  
    const allDropdown = document.getElementById('allDropdown');  
    const records = document.querySelectorAll('[data-record]');  
  
    // Toggle dropdown visibility  
    activityBtn.addEventListener('click', () => { activityDropdown.classList.toggle('show'); allDropdown.classList.remove('show'); });  
    allBtn.addEventListener('click', () => { allDropdown.classList.toggle('show'); activityDropdown.classList.remove('show'); });  
  
    // Filter function  
    function filterRecords(types) {  
      records.forEach(r => {  
        if(types.includes(r.dataset.record)) r.style.display='block';  
        else r.style.display='none';  
      });  
    }  
  
    // Activity dropdown options  
    activityDropdown.querySelectorAll('button').forEach(btn => {  
      btn.addEventListener('click', () => {  
        const type = btn.dataset.filter;  
        filterRecords([type]);  
        activityDropdown.classList.remove('show');  
      });  
    });  
  
    // All dropdown options  
    allDropdown.querySelectorAll('button').forEach(btn => {  
      btn.addEventListener('click', () => {  
        const type = btn.dataset.filter;  
        filterRecords([type]);  
        allDropdown.classList.remove('show');  
      });  
    });  
  
    // Click outside to close  
    document.addEventListener('click', (e)=>{  
      if(!activityBtn.contains(e.target) && !activityDropdown.contains(e.target)) activityDropdown.classList.remove('show');  
      if(!allBtn.contains(e.target) && !allDropdown.contains(e.target)) allDropdown.classList.remove('show');  
    });  
  </script>    <?php include 'bottom_nav.php'; ?>  </body>  
</html>