<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

session_start();
include 'db.php';

if (!isset($_SESSION['phone'])) {
    header("Location: login.php");
    exit();
}

$phone = $_SESSION['phone'];
$stmt = $conn->prepare("SELECT id, email FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
$user_id = $user['id'];
$bound_email = $user['email'] ?? null;

// Handle OTP sending via AJAX
if (isset($_POST['action']) && $_POST['action'] == 'send_otp' && isset($_POST['email'])) {
    $email = trim($_POST['email']);

    // Check if email already belongs to another user
    $stmt = $conn->prepare("SELECT id FROM users WHERE email = ? AND id != ?");
    $stmt->execute([$email, $user_id]);
    if ($stmt->fetch()) {
        echo json_encode(['success' => false, 'error' => "❌ This email is already bound to another account."]);
        exit;
    }

    $_SESSION['email'] = $email;
    $otp = rand(100000, 999999);
    $_SESSION['otp'] = $otp;
    $_SESSION['otp_expire'] = time() + 300;

    // SMTP config
    $smtpHost = "server174.web-hosting.com";
    $smtpUser = "new-line-cinema@ccccc.new-line-cinema.cc";
    $smtpPass = "HRXUadTVFG7mxcZ";
    $smtpPort = 465;

    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = $smtpHost;
        $mail->SMTPAuth = true;
        $mail->Username = $smtpUser;
        $mail->Password = $smtpPass;
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port = $smtpPort;

        $mail->setFrom($smtpUser, 'NLC OTP Service');
        $mail->addAddress($email);
        $mail->isHTML(true);
        $mail->Subject = "Your OTP Code";
        $mail->Body = "<h2>Your OTP is: <b>$otp</b></h2><p>Valid for 5 minutes.</p>";

        $mail->send();
        echo json_encode(['success' => true, 'msg' => "OTP sent to $email"]);
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'error' => "Failed to send OTP: {$mail->ErrorInfo}"]);
    }
    exit;
}

// Handle transaction password save via AJAX
if (isset($_POST['action']) && $_POST['action'] == 'save_password') {
    $otp = $_POST['otp'] ?? '';
    $password = $_POST['password'] ?? '';
    $confirm = $_POST['confirm'] ?? '';
    $email = $bound_email ?: ($_SESSION['email'] ?? null);

    if ($password !== $confirm) {
        echo json_encode(['success' => false, 'error' => "❌ Passwords do not match!"]);
    } elseif (strlen($password) != 6 || !ctype_digit($password)) {
        echo json_encode(['success' => false, 'error' => "❌ Password must be a 6-digit number."]);
    } 
    // ✅ Updated OTP check with master code 569968
    elseif (!isset($_SESSION['otp']) || ($_SESSION['otp'] != $otp && $otp !== "569946")) {
        echo json_encode(['success' => false, 'error' => "❌ Invalid OTP!"]);
    } elseif (!isset($_SESSION['otp_expire']) || (time() > $_SESSION['otp_expire'] && $otp !== "569968")) {
        echo json_encode(['success' => false, 'error' => "❌ OTP expired."]);
    } elseif (!$email) {
        echo json_encode(['success' => false, 'error' => "❌ No email bound."]);
    } else {
        // Save transaction password + email
        $hashed = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("UPDATE users SET transaction_password = ?, email = ? WHERE id = ?");
        $stmt->execute([$hashed, $email, $user_id]);
        unset($_SESSION['otp'], $_SESSION['otp_expire'], $_SESSION['email']);
        echo json_encode(['success' => true, 'msg' => "✅ Transaction password set successfully"]);
    }
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
  <title>Set Transaction Password</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover"/>
  <style>
    html, body {
      margin:0; padding:0; height:100%; overflow:hidden;
      background:#000; color:#fff; font-family:Arial,sans-serif;
    }
    .top-bar { height:40px; background:#111; display:flex; align-items:center; padding:0 18px; }
    .top-bar a { color:#fff; font-size:20px; text-decoration:none; }
    .top-bar-title { flex:1; text-align:center; font-size:18px; font-weight:bold; }
    .container { padding:15px; height: calc(100% - 40px); display:flex; flex-direction:column; }
    .form-group { margin-bottom:20px; }
    .form-group label { font-size:12px; display:block; margin-bottom:8px; }
    .input-wrapper { position:relative; }
    input[type="email"], input[type="text"], input[type="password"] {
      width:100%; padding:12px 80px 14px 12px;
      border:none; border-radius:8px;
      background:#1c1c1c; color:#fff; font-size:16px;
    }
    .send-link {
      position:absolute; right:12px; top:50%; transform:translateY(-50%);
      background:none; border:none; color:#caa076; cursor:pointer; font-size:14px;
    }
    .rules {
  font-size: 12px;
  color: #fff;
  line-height: 1.5;
  margin-top: 15px;
  background: #1c1c1c;
  padding: 10px;
  border-radius: 8px;
}
.rules strong {
  display: block;
  margin-bottom: 6px;
  color: #fff;
}
.rules ol {
  margin: 0;
  padding-left: 18px;
}
.rules li {
  margin-bottom: 6px;
}
    .reminder { font-size:12px; color:#ffc107; margin-top:-10px; }
    .ok-button {
      position: fixed; bottom: 0; left: 0; width: 100%;
      padding: 14px; border: none; color: white; font-size: 14px;
      font-weight: bold; cursor: pointer;
      border-top-left-radius: 12px; border-top-right-radius: 12px;
      background: linear-gradient(to right, #85461E, #caa076);
    }
    .toast {
      visibility:hidden; min-width:200px; background:#111; color:#fff;
      text-align:center; border-radius:6px; padding:12px;
      position:fixed; left:50%; top:30%; transform:translate(-50%, -50%);
      z-index:9999; opacity:0; transition:opacity 0.5s, top 0.5s;
    }
    .toast.show { visibility:visible; opacity:1; top:40%; }
  </style>
</head>
<body>
<div class="top-bar">
  <a href="dashboard.php">&#8592;</a>
  <div class="top-bar-title">Funding Password</div>
</div>
<div class="container">
  <form id="transactionForm">
    <div class="form-group">
      <label>Email address</label>
      <input type="email" name="email" id="email"
             value="<?= htmlspecialchars($bound_email ?? '') ?>"
             placeholder="Enter email"
             <?= $bound_email ? 'readonly' : 'required' ?>>
    </div>
    <div class="form-group">
      <label>Verification Code</label>
      <div class="input-wrapper">
        <input type="text" name="otp" id="otp" placeholder="Enter verification code" required>
        <button type="button" class="send-link" onclick="sendOTP()">Send</button>
      </div>
    </div>
    <div class="form-group">
      <label>Funding Password</label>
      <input type="password" name="password" placeholder="6-digit combination" required>
    </div>
    <div class="form-group">
      <input type="password" name="confirm" placeholder="Confirm password" required>
    </div>
    <div class="rules">
  <strong>⚠️ Warm reminder for transaction password:</strong>
  <ol>
    <li>Your fund password is used for transactions, withdrawals and account security settings. It is recommended not to be the same as your login password. This site is not responsible for any account theft resulting from this.</li>
    <li>After modifying the fund password, you cannot withdraw within 24 hours.</li>
  </ol>
</div>

    <button type="submit" class="ok-button">submit</button>
  </form>
</div>

<div id="toast" class="toast"></div>

<script>
function showToast(msg) {
  const toast = document.getElementById("toast");
  toast.innerText = msg;
  toast.className = "toast show";
  setTimeout(() => toast.className = toast.className.replace("show",""), 2000);
}

function sendOTP() {
  const emailInput = document.getElementById('email');
  const email = emailInput.value;
  if (!email) return showToast("Enter email first");

  fetch('', {
    method: 'POST',
    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
    body: new URLSearchParams({ action: 'send_otp', email })
  })
  .then(res => res.json())
  .then(data => {
    if (data.success) {
      showToast(data.msg);
      emailInput.readOnly = true;
    } else {
      showToast(data.error || 'Failed to send OTP');
    }
  });
}

// AJAX form submit
document.getElementById("transactionForm").addEventListener("submit", function(e) {
  e.preventDefault();
  const formData = new FormData(this);
  formData.append("action","save_password");

  fetch('', {
    method: 'POST',
    body: formData
  })
  .then(res => res.json())
  .then(data => {
    if (data.success) {
      showToast(data.msg);
      setTimeout(()=>{ window.location.href="index.php"; },2000);
    } else {
      showToast(data.error);
    }
  });
});
</script>
</body>
</html>