<?php  
session_start();  
include 'db.php';  

if (!isset($_SESSION['phone'])) {  
    header("Location: login.php");  
    exit();  
}  

$phone = $_SESSION['phone'];  

// ✅ Get current user's invite_code
$stmt = $conn->prepare("SELECT invite_code FROM users WHERE phone = ?");  
$stmt->execute([$phone]);  
$current_code = $stmt->fetchColumn();  

if (!$current_code) {  
    echo "<p class='text-center text-red-500 font-semibold'>Invitation code not found for this user.</p>";
    exit();  
}  

// ✅ Function to get team members by referral level with "Active / Non Active" status
function getTeamMembersWithVIP($conn, $ref_code, $level) {  
    $members = [];  

    // 🔹 Query (uses recharge_records table correctly)
    $query = "
        SELECT 
            u.id, 
            u.phone, 
            u.invite_code, 
            u.invited_by, 
            u.created_at,
            (SELECT COUNT(*) FROM users WHERE invited_by = u.invite_code) AS direct_push,
            CASE 
                WHEN EXISTS (
                    SELECT 1 FROM recharge_records r 
                    WHERE r.phone = u.phone 
                    AND r.status = 'success'
                ) THEN 'Active' 
                ELSE 'Non Active' 
            END AS vip_status
        FROM users u 
        WHERE u.invited_by = ?
        ORDER BY u.created_at DESC
    ";

    // 🔹 LEVEL 1
    if ($level == 1) {  
        $stmt = $conn->prepare($query);
        $stmt->execute([$ref_code]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }  

    // 🔹 LEVEL 2
    if ($level == 2) {  
        $stmt = $conn->prepare("SELECT invite_code FROM users WHERE invited_by = ?");
        $stmt->execute([$ref_code]);
        $level1_codes = $stmt->fetchAll(PDO::FETCH_COLUMN);

        if ($level1_codes) {
            foreach ($level1_codes as $code) {
                $stmt2 = $conn->prepare($query);
                $stmt2->execute([$code]);
                $members = array_merge($members, $stmt2->fetchAll(PDO::FETCH_ASSOC));
            }
        }
        return $members;
    }  

    // 🔹 LEVEL 3
    if ($level == 3) {  
        $stmt = $conn->prepare("SELECT invite_code FROM users WHERE invited_by = ?");
        $stmt->execute([$ref_code]);
        $level1_codes = $stmt->fetchAll(PDO::FETCH_COLUMN);

        foreach ($level1_codes as $code1) {  
            $stmt2 = $conn->prepare("SELECT invite_code FROM users WHERE invited_by = ?");
            $stmt2->execute([$code1]);
            $level2_codes = $stmt2->fetchAll(PDO::FETCH_COLUMN);  

            foreach ($level2_codes as $code2) {  
                $stmt3 = $conn->prepare($query);
                $stmt3->execute([$code2]);
                $members = array_merge($members, $stmt3->fetchAll(PDO::FETCH_ASSOC));  
            }  
        }  
        return $members;
    }  

    return $members;  
}  

// ✅ Get members for all 3 levels
$level1_members = getTeamMembersWithVIP($conn, $current_code, 1);  
$level2_members = getTeamMembersWithVIP($conn, $current_code, 2);  
$level3_members = getTeamMembersWithVIP($conn, $current_code, 3);  
?>

<!DOCTYPE html>
<html lang="en">
<head>  
  <meta charset="UTF-8" />  
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <title>Team Members</title>  
  <script src="https://cdn.tailwindcss.com"></script>  
  <style>
    .active-tab {
      background: linear-gradient(to bottom, #fff8e3, #ffd78a);  
      color: black;
      font-weight: bold;
    }
    .inactive-tab {
      background-color: #222;
      color: #ccc;
    }
  </style>
  <script>
    function showLevel(level) {
      document.querySelectorAll('.level-list').forEach(div => div.classList.add('hidden'));
      document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active-tab'));
      document.getElementById('level-' + level).classList.remove('hidden');
      document.getElementById('tab-' + level).classList.add('active-tab');
    }
  </script>
</head>

<body class="bg-black text-white font-sans min-h-screen">
  <div class="max-w-md mx-auto p-4 space-y-4">

    <!-- Header -->
    <div class="flex items-center space-x-3 mb-2">
      <a href="dashboard.php" class="text-white text-2xl">&#8592;</a>
      <h1 class="text-xl font-semibold text-center flex-1">Member List</h1>
    </div>

    <!-- Tabs -->
    <div class="grid grid-cols-3 text-center rounded-lg overflow-hidden">
      <button id="tab-1" onclick="showLevel(1)" class="tab-btn active-tab py-2 text-sm">First generation</button>
      <button id="tab-2" onclick="showLevel(2)" class="tab-btn inactive-tab py-2 text-sm">Second generation</button>
      <button id="tab-3" onclick="showLevel(3)" class="tab-btn inactive-tab py-2 text-sm">Third generation</button>
    </div>

    <!-- LEVEL 1 -->
    <div id="level-1" class="level-list space-y-3 mt-4">
      <?php if (!empty($level1_members)): ?>
        <?php foreach ($level1_members as $member): ?>
          <div class="bg-[#1A1A1A] p-3 rounded-lg flex items-center space-x-3">
            <img src="https://i.ibb.co/2hc6xWW/logo.png" class="w-10 h-10 rounded-full border border-gray-700">
            <div class="flex-1">
              <div class="text-lg font-semibold"><?= htmlspecialchars($member['id']) ?></div>
              <div class="text-sm text-gray-400">
                <?= substr_replace($member['phone'], '****', 4, 4) ?><br>
                <?php if ($member['vip_status'] === 'Active'): ?>
                  <span class="text-green-400 font-semibold">Active</span>
                <?php else: ?>
                  <span class="text-red-400 font-semibold">Non Active</span>
                <?php endif; ?>
              </div>
            </div>
            <div class="text-right text-sm">
              <div>Direct push number: <span class="text-green-400"><?= $member['direct_push'] ?></span></div>
              <div>Registration Date<br><span class="text-gray-400"><?= $member['created_at'] ?></span></div>
            </div>
          </div>
        <?php endforeach; ?>
      <?php else: ?>
        <div class="text-center text-gray-500 mt-10">No members found</div>
      <?php endif; ?>
    </div>

    <!-- LEVEL 2 -->
    <div id="level-2" class="level-list space-y-3 mt-4 hidden">
      <?php if (!empty($level2_members)): ?>
        <?php foreach ($level2_members as $member): ?>
          <div class="bg-[#1A1A1A] p-3 rounded-lg flex items-center space-x-3">
            <img src="https://i.ibb.co/2hc6xWW/logo.png" class="w-10 h-10 rounded-full border border-gray-700">
            <div class="flex-1">
              <div class="text-lg font-semibold"><?= htmlspecialchars($member['id']) ?></div>
              <div class="text-sm text-gray-400">
                <?= substr_replace($member['phone'], '****', 4, 4) ?><br>
                <?php if ($member['vip_status'] === 'Active'): ?>
                  <span class="text-green-400 font-semibold">Active</span>
                <?php else: ?>
                  <span class="text-red-400 font-semibold">Non Active</span>
                <?php endif; ?>
              </div>
            </div>
            <div class="text-right text-sm">
              <div>Direct push number: <span class="text-green-400"><?= $member['direct_push'] ?></span></div>
              <div>Registration Date<br><span class="text-gray-400"><?= $member['created_at'] ?></span></div>
            </div>
          </div>
        <?php endforeach; ?>
      <?php else: ?>
        <div class="text-center text-gray-500 mt-10">No members found</div>
      <?php endif; ?>
    </div>

    <!-- LEVEL 3 -->
    <div id="level-3" class="level-list space-y-3 mt-4 hidden">
      <?php if (!empty($level3_members)): ?>
        <?php foreach ($level3_members as $member): ?>
          <div class="bg-[#1A1A1A] p-3 rounded-lg flex items-center space-x-3">
            <img src="https://i.ibb.co/2hc6xWW/logo.png" class="w-10 h-10 rounded-full border border-gray-700">
            <div class="flex-1">
              <div class="text-lg font-semibold"><?= htmlspecialchars($member['id']) ?></div>
              <div class="text-sm text-gray-400">
                <?= substr_replace($member['phone'], '****', 4, 4) ?><br>
                <?php if ($member['vip_status'] === 'Active'): ?>
                  <span class="text-green-400 font-semibold">Active</span>
                <?php else: ?>
                  <span class="text-red-400 font-semibold">Non Active</span>
                <?php endif; ?>
              </div>
            </div>
            <div class="text-right text-sm">
              <div>Direct push number: <span class="text-green-400"><?= $member['direct_push'] ?></span></div>
              <div>Registration Date<br><span class="text-gray-400"><?= $member['created_at'] ?></span></div>
            </div>
          </div>
        <?php endforeach; ?>
      <?php else: ?>
        <div class="text-center text-gray-500 mt-10">No members found</div>
      <?php endif; ?>
    </div>

  </div>
</body>
</html>