<?php  
ini_set('display_errors', 1);  
error_reporting(E_ALL);  
session_start();  
include('db.php');  
  
if (!isset($_SESSION['phone'])) {  
    header("Location: login.php");  
    exit();  
}  
  
$phone = $_SESSION['phone'];  
$selected_vip_id = isset($_GET['vip']) ? (int)$_GET['vip'] : 0;  
  
// Get user  
$stmt = $conn->prepare("SELECT * FROM users WHERE phone = ?");  
$stmt->execute([$phone]);  
$user = $stmt->fetch();  
  
if (!$user) {  
    echo "<p style='color:white;'>User not found.</p>";  
    exit();  
}  
  
$user_id = $user['id'];  
  
if ($selected_vip_id == 0) {  
    $vip = [  
        'name' => 'VIP 0',  
        'daily_earning_limit' => 1,  
        'viewing_income' => 0,  
        'valid_days' => 1,  
        'purchased_at' => date('Y-m-d H:i:s')  
    ];  
  
    $stmt = $conn->prepare("SELECT * FROM videos WHERE vip_product_id = 0 ORDER BY id ASC");  
    $stmt->execute();  
    $videos = $stmt->fetchAll();  
  
} else {  
    $stmt = $conn->prepare("  
        SELECT p.*, v.name, v.daily_earning_limit, v.viewing_income, v.valid_days, p.expire_at  
        FROM purchases p  
        JOIN vip_products v ON p.vip_product_id = v.id  
        WHERE p.user_id = ? AND p.vip_product_id = ?  
        ORDER BY p.purchased_at DESC LIMIT 1  
    ");  
    $stmt->execute([$user_id, $selected_vip_id]);  
    $vip = $stmt->fetch();  
  
    if (!$vip) {  
        echo "<p style='color:white;'>You have not purchased VIP $selected_vip_id.</p>";  
        exit();  
    }  
  
    $purchaseDateStr = $vip['purchased_at'] ?? null;  
    if (!$purchaseDateStr) {  
        echo "<p style='color:white;'>Purchase date not found for this VIP.</p>";  
        exit();  
    }  
  
    $today = new DateTime();  
    $expiry_date = !empty($vip['expire_at'])  
        ? new DateTime($vip['expire_at'])  
        : (new DateTime($purchaseDateStr))->modify("+{$vip['valid_days']} days");  
  
    if ($today > $expiry_date) {  
        echo "<p style='color:white;'>Your VIP access for VIP {$vip['name']} has expired.</p>";  
        exit();  
    }  
  
    $stmt = $conn->prepare("SELECT * FROM videos WHERE vip_product_id = ? ORDER BY id ASC");  
    $stmt->execute([$selected_vip_id]);  
    $videos = $stmt->fetchAll();  
}  
  
shuffle($videos);  
  
// Task counts  
$total_tasks = (int)$vip['daily_earning_limit'];  
$stmt = $conn->prepare("SELECT COUNT(*) FROM task_records WHERE user_id = ? AND vip_product_id = ? AND DATE(scored_at) = CURDATE()");  
$stmt->execute([$user_id, $selected_vip_id]);  
$completed_tasks = (int)$stmt->fetchColumn();  
$remaining_tasks = max(0, $total_tasks - $completed_tasks);  

// ✅ Countdown: reduce 1 day from VIP if user finished all tasks today
if ($completed_tasks >= $total_tasks && $selected_vip_id != 0) {
    $stmt = $conn->prepare("UPDATE purchases SET expire_at = DATE_SUB(expire_at, INTERVAL 1 DAY) WHERE user_id = ? AND vip_product_id = ? AND expire_at > NOW() ORDER BY purchased_at DESC LIMIT 1");
    $stmt->execute([$user_id, $selected_vip_id]);
}
?>  

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>VIP Task Area - <?= htmlspecialchars($vip['name']) ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<script src="https://cdn.tailwindcss.com"></script>
<style>
body {
  font-family: Arial, sans-serif;
  background-color: #111;
  color: #fff;
  margin: 0;
  padding: 0;
}

/* Top Header with Gradient */
.header {
  background: linear-gradient(180deg, #F8D9A0 0%, #FFF4D6 100%);
  color: #000;
  font-weight: bold;
  padding: 1rem;
  display: flex;
  justify-content: center;
  align-items: center;
  position: sticky;
  top: 0;
  z-index: 10;
}

.header a {
  position: absolute;
  left: 1rem;
  color: #000;
  font-size: 1.5rem;
  text-decoration: none;
}

/* Video grid */
.video-grid {
  display: grid;
  grid-template-columns: repeat(2, 1fr);
  gap: 0.8rem;
  padding: 1rem;
}

/* Video cards */
.video-item {
  background-color: #1A1A1A;
  border-radius: 0.5rem;
  overflow: hidden;
  cursor: pointer;
  transition: transform 0.2s;
}

.video-item:hover {
  transform: scale(1.02);
}

.video-thumb {
  width: 100%;
  height: 180px;
  object-fit: cover;
}

.video-info {
  padding: 0.6rem;
}

.video-title {
  font-weight: bold;
  font-size: 0.9rem;
  text-align: left;
  margin-bottom: 0.4rem;
}

/* Progress and Ticket */
.progress-bar {
  background-color: #333;
  border-radius: 0.25rem;
  overflow: hidden;
  height: 6px;
  margin-bottom: 0.3rem;
}

.progress-fill {
  background: linear-gradient(180deg, #F8D9A0 0%, #FFF4D6 100%);
  height: 6px;
  width: 80%;
}

.ticket-label {
  font-size: 0.8rem;
  color: #ccc;
  margin-bottom: 0.5rem;
}

/* Rating button with gradient */
.rating-btn {
  background: linear-gradient(180deg, #F8D9A0 0%, #FFF4D6 100%);
  color: #000;
  font-weight: bold;
  text-align: center;
  padding: 0.4rem 0;
  border-radius: 0.25rem;
  font-size: 0.85rem;
  transition: 0.2s;
  border: none;
}

.rating-btn:hover {
  background: linear-gradient(180deg, #FFEAB6 0%, #FFFFFF 100%);
}
</style>
</head>
<body>
<!-- Header -->
<div class="header">
  <a href="index.php">&#8592;</a>
  <div>Scoring Center</div>
</div>

<!-- Video Grid -->
<div class="video-grid">
<?php foreach ($videos as $video):
  $url = $video['video_url'];
  $title = htmlspecialchars($video['title']);

  if (!empty($video['thumbnail'])) {
    $thumb = $video['thumbnail'];
  } elseif (strpos($url, 'streamable.com') !== false) {
    $streamable_id = basename($url);
    $thumb = "https://cdn-cf-east.streamable.com/image/$streamable_id.jpg";
  } elseif (strpos($url, 'youtube.com') !== false || strpos($url, 'youtu.be') !== false) {
    preg_match('/(?:v=|\/)([0-9A-Za-z_-]{11})/', $url, $matches);
    $youtube_id = $matches[1] ?? '';
    $thumb = "https://img.youtube.com/vi/$youtube_id/hqdefault.jpg";
  } else {
    $thumb = 'https://img.icons8.com/ios/100/ffffff/video.png';
  }

  $tickets = rand(630000, 660000);
?>
  <div class="video-item" onclick="window.location.href='watch_task.php?task_id=<?= $video['id'] ?>'">
    <img src="<?= $thumb ?>" alt="<?= $title ?>" class="video-thumb">
    <div class="video-info">
      <div class="video-title"><?= $title ?></div>
      <div class="progress-bar"><div class="progress-fill" style="width: <?= rand(60, 100) ?>%;"></div></div>
      <div class="ticket-label"><?= $tickets ?> Ticket</div>
      <div class="rating-btn">Rating immediately</div>
    </div>
  </div>
<?php endforeach; ?>
</div>

<script>
window.addEventListener("pageshow", function(event) {
  if (event.persisted || (performance.getEntriesByType("navigation")[0]?.type === "back_forward")) {
    location.reload();
  }
});
</script>
</body>
</html>