<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
include('db.php');

if (!isset($_SESSION['phone'])) {
    header("Location: login.php");
    exit();
}

$phone = $_SESSION['phone'];
$stmt = $conn->prepare("SELECT * FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch();

if (!$user) {
    echo "User not found.";
    exit();
}

$user_id = $user['id'];

$stmt = $conn->prepare("SELECT tr.*, v.title AS video_title, v.thumbnail AS video_thumbnail, 
                               vp.name AS vip_name, vp.viewing_income 
                        FROM task_records tr
                        JOIN videos v ON tr.video_id = v.id
                        JOIN vip_products vp ON tr.vip_product_id = vp.id
                        WHERE tr.user_id = ?
                        ORDER BY tr.scored_at DESC");
$stmt->execute([$user_id]);
$records = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Historical Score Record</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover"/>
    <style>
        body {
            background: #000;
            color: #fff;
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }

        /* Header */
        .header {
            background: #111;
            color: white;
            font-size: 18px;
            font-weight: bold;
            text-align: center;
            padding: 14px;
            position: sticky;
            top: 0;
            z-index: 10;
        }

        .header a {
            position: absolute;
            left: 10px;
            top: 12px;
            font-size: 22px;
            color: white;
            text-decoration: none;
        }

        /* Grid Layout */
        .record-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
            padding: 12px;
        }

        .record-card {
            background: #1c1c1c;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 0 5px rgba(0,0,0,0.3);
        }

        .record-card img {
            width: 100%;
            height: 150px;
            object-fit: cover;
            display: block;
        }

        .record-info {
            padding: 8px;
            font-size: 13px;
            line-height: 1.5;
        }

        .record-info .revenue {
            background: linear-gradient(180deg, #FFEAB6 0%, #FFFFFF 100%);
-webkit-background-clip: text;
-webkit-text-fill-color: transparent;
            font-weight: bold;
        }

        .record-info small {
            color: #ccc;
            display: block;
            margin-top: 3px;
        }

        /* Empty State */
        .no-records {
            text-align: center;
            margin-top: 100px;
        }

        .no-records img {
            width: 120px;
            opacity: 0.6;
        }

        .no-records p {
            color: #aaa;
            margin-top: 10px;
            font-size: 15px;
        }
    </style>
</head>
<body>

<div class="header">
    <a href="javascript:history.back()">&#8592;</a>
    Historical score record
</div>

<?php if (empty($records)): ?>
    <div class="no-records">
        <img src="https://img.icons8.com/fluency/96/video.png" alt="No Records">
        <p>No task records found yet.</p>
    </div>
<?php else: ?>
    <div class="record-grid">
        <?php foreach ($records as $record): ?>
            <div class="record-card">
                <img src="<?php echo htmlspecialchars($record['video_thumbnail']); ?>" alt="Video Thumbnail">
                <div class="record-info">
                    <div>Revenue: <span class="revenue"><?php echo number_format($record['amount'], 1); ?> USDT</span></div>
                    <small>time: <?php echo date('Y-m-d H:i:s', strtotime($record['scored_at'])); ?></small>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<?php include 'bottom_nav.php'; ?>

</body>
</html>