<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
include '../db.php';

if (!isset($_SESSION['phone'])) {
    header("Location: ../auth/login.php");
    exit();
}

$phone = $_SESSION['phone'];
$vip_id = isset($_GET['vip']) ? intval($_GET['vip']) : 1;

// Get user ID
$stmt = $conn->prepare("SELECT id FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
$user_id = $user['id'];

// Check VIP purchase
$stmt = $conn->prepare("SELECT * FROM purchases WHERE user_id = ? AND vip_product_id = ?");
$stmt->execute([$user_id, $vip_id]);
$purchase = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$purchase) {
    die("<div style='color:white; padding:20px; background-color:black;'>You have not purchased VIP $vip_id. <a href='../vip_products.php' style='color:yellow;'>Go back</a></div>");
}

// Check if VIP has expired
$stmt = $conn->prepare("SELECT valid_days FROM vip_products WHERE id = ?");
$stmt->execute([$vip_id]);
$vip = $stmt->fetch(PDO::FETCH_ASSOC);

$purchase_date = new DateTime($purchase['purchase_date']);
$expiry_date = clone $purchase_date;
$expiry_date->modify("+{$vip['valid_days']} days");
$now = new DateTime();

if ($now > $expiry_date) {
    die("<div style='color:white; padding:20px; background-color:black;'>Your VIP $vip_id has expired. <a href='../vip_products.php' style='color:yellow;'>Renew</a></div>");
}

// Get videos for selected VIP
$stmt = $conn->prepare("SELECT * FROM videos WHERE vip_id = ? ORDER BY id DESC");
$stmt->execute([$vip_id]);
$videos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>VIP <?= $vip_id ?> Tasks</title>
    <style>
        body {
            margin: 0;
            background-color: #000;
            font-family: Arial, sans-serif;
            color: white;
        }
        .video-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 16px;
            padding: 20px;
            box-sizing: border-box;
        }
        .video-card {
            background-color: #1c1c1c;
            border-radius: 10px;
            overflow: hidden;
            text-align: center;
            box-shadow: 0 0 10px rgba(0,0,0,0.6);
        }
        .video-card iframe {
            width: 100%;
            height: 180px;
            border: none;
        }
        .video-card h3 {
            margin: 10px 0;
            font-size: 18px;
        }
        .video-card a {
            display: inline-block;
            margin: 10px 0 15px 0;
            padding: 10px 20px;
            background-color: #ffcc00;
            color: #000;
            text-decoration: none;
            border-radius: 6px;
            font-weight: bold;
        }
    </style>
</head>
<body>

<div class="video-grid">
    <?php foreach ($videos as $video): ?>
        <div class="video-card">
            <iframe src="<?= htmlspecialchars($video['video_url']) ?>" allowfullscreen></iframe>
            <h3><?= htmlspecialchars($video['title']) ?></h3>
            <a href="../watch_task.php?task_id=<?= $video['id'] ?>">Start Task</a>
        </div>
    <?php endforeach; ?>
</div>

</body>
</html>