<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
include 'db.php';

$stmt = $conn->prepare("SELECT * FROM support_numbers ORDER BY created_at DESC");
$stmt->execute();
$numbers = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Customer Support</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      margin: 0;
      background: #000;
      color: #fff;
      font-family: Arial, sans-serif;
    }

    .top-bar {
      display: flex;
      align-items: center;
      justify-content: center;
      height: 50px;
      background-color: #111;
      border-bottom: 1px solid #333;
      position: relative;
      z-index: 10;
    }

    .back-arrow {
      position: absolute;
      left: 10px;
      font-size: 22px;
      cursor: pointer;
      color: white;
    }

    .title {
      font-size: 18px;
      font-weight: bold;
    }

    .content {
      padding: 140px 20px 20px; /* top padding for the chat button */
      text-align: center;
    }

    .support-button {
      display: block;
      background: #00ffcc;
      color: #000;
      font-weight: bold;
      padding: 15px 20px;
      margin: 10px auto;
      width: 90%;
      max-width: 400px;
      border-radius: 8px;
      text-align: center;
      text-decoration: none;
      font-size: 18px;
      transition: background 0.3s, transform 0.2s;
    }

    .support-button:hover {
      background: #00e6b8;
      transform: scale(1.03);
    }

    /* Tawk.to button */
    .tawk-button {
      position: fixed;
      top: 60px; /* just below top bar */
      left: 50%;
      transform: translateX(-50%);
      background: #00aabb;
      color: #fff;
      font-weight: bold;
      padding: 15px 25px;
      border-radius: 30px;
      font-size: 18px;
      text-decoration: none;
      text-align: center;
      max-width: 400px;
      width: 90%;
      box-shadow: 0 4px 12px rgba(0,170,187,0.4);
      transition: background 0.3s, transform 0.2s;
      z-index: 9999;
      cursor: pointer;
    }

    .tawk-button:hover {
      background: #00ccee;
      transform: scale(1.05);
    }

    /* WhatsApp Floating Icon */
    .whatsapp-float {
      position: fixed;
      bottom: 110px; /* moved up so it doesn’t overlap Tawk.to */
      right: 25px;
      background: #25D366;
      color: white;
      border-radius: 50%;
      width: 60px;
      height: 60px;
      text-align: center;
      font-size: 30px;
      line-height: 60px;
      box-shadow: 0 4px 10px rgba(0,0,0,0.3);
      z-index: 999999; /* stays on top of everything */
      transition: transform 0.3s, box-shadow 0.3s;
      animation: bounce 2s infinite;
    }

    .whatsapp-float:hover {
      transform: scale(1.15);
      box-shadow: 0 6px 14px rgba(0,0,0,0.4);
    }

    .whatsapp-float i {
      color: white;
    }

    /* Simple bounce animation */
    @keyframes bounce {
      0%, 20%, 50%, 80%, 100% {
        transform: translateY(0);
      }
      40% {
        transform: translateY(-10px);
      }
      60% {
        transform: translateY(-5px);
      }
    }
  </style>
  <!-- Font Awesome for WhatsApp icon -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
</head>
<body>

  <div class="top-bar">
    <div class="back-arrow" onclick="history.back()">←</div>
    <div class="title">Customer Support</div>
  </div>

  <!-- Long button to open Tawk.to chat at top -->
  <div class="tawk-button" onclick="Tawk_API.toggle()">
    💬 Chat with Customer Service
  </div>

  <div class="content">
    <?php if (count($numbers) > 0): ?>
      <?php foreach ($numbers as $row): ?>
        <a href="tel:<?= htmlspecialchars($row['phone_number']) ?>" class="support-button">
          <?= htmlspecialchars($row['phone_number']) ?>
        </a>
      <?php endforeach; ?>
    <?php else: ?>
      <p></p>
    <?php endif; ?>
  </div>

  <!-- WhatsApp Floating Icon -->
  <a href="https://wa.me/447902954842" target="_blank" class="whatsapp-float" title="Chat on WhatsApp">
    <i class="fab fa-whatsapp"></i>
  </a>

  <!-- Tawk.to Live Chat Widget -->
  <!--Start of Tawk.to Script-->
  <script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
      var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
      s1.async=true;
      s1.src='https://embed.tawk.to/68e76e26a7325b1953ad9e40/1j740cih3';
      s1.charset='UTF-8';
      s1.setAttribute('crossorigin','*');
      s0.parentNode.insertBefore(s1,s0);
    })();
  </script>
  <!--End of Tawk.to Script-->

</body>
</html>