<?php
session_start();
include 'db.php';

if (!isset($_SESSION['phone'])) {
    echo "❌ Not logged in.";
    exit;
}

// Fetch phone number from session (already stored during login)
$phone = $_SESSION['phone']; // Example: 08012345678

// Format number for WhatsApp (no leading 0, add country code e.g. 234)
if (substr($phone, 0, 1) === '0') {
    $phone = '234' . substr($phone, 1);
}

$otp = rand(100000, 999999);
$_SESSION['otp'] = $otp;
$_SESSION['otp_sent_time'] = time();
$_SESSION['otp_expire'] = time() + 300; // 5 mins

// UltraMsg setup
$token = "YOUR_ULTRAMSG_TOKEN";
$instance_id = "YOUR_INSTANCE_ID";

$params = array(
    'token' => $token,
    'to' => $phone,
    'body' => "Your TG Wine OTP is: $otp",
    'priority' => '10',
    'referenceId' => '',
    'msgId' => '',
    'mentions' => ''
);

$curl = curl_init();
curl_setopt_array($curl, array(
    CURLOPT_URL => "https://api.ultramsg.com/$instance_id/messages/chat",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_SSL_VERIFYHOST => 0,
    CURLOPT_SSL_VERIFYPEER => 0,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => http_build_query($params),
    CURLOPT_HTTPHEADER => array(
        "content-type: application/x-www-form-urlencoded"
    ),
));

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    echo "❌ WhatsApp Error: " . $err;
} else {
    echo "✅ OTP sent to WhatsApp: $phone";
}
?>