<?php
session_start();
include 'db.php'; // your database connection file

header('Content-Type: application/json');

if (!isset($_SESSION['phone'])) {
    echo json_encode(["error" => "❌ Not logged in."]);
    exit;
}

// Get user's email from database
$phone = $_SESSION['phone'];
$stmt = $conn->prepare("SELECT email FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user || empty($user['email'])) {
    echo json_encode(["error" => "❌ No email found for user."]);
    exit;
}

$email = $user['email'];

// Prevent resending too fast (60 sec)
if (isset($_SESSION['otp_sent_time']) && time() - $_SESSION['otp_sent_time'] < 60) {
    echo json_encode(["error" => "⏱️ Please wait before resending OTP."]);
    exit;
}

// Generate OTP and save in session
$otp = rand(100000, 999999);
$_SESSION['otp'] = $otp;
$_SESSION['otp_sent_time'] = time();
$_SESSION['otp_expire'] = time() + 300; // expires in 5 mins

// Email content
$subject = "Your OTP Code";
$message = "Your one-time password (OTP) is: $otp\nIt will expire in 5 minutes.";
$headers = "From: no-reply@" . $_SERVER['SERVER_NAME'];

if (mail($email, $subject, $message, $headers)) {
    echo json_encode(["success" => "✅ OTP sent to $email"]);
} else {
    echo json_encode(["error" => "❌ Failed to send OTP."]);
}
?>