<?php
session_start();
include 'db.php'; // Make sure this connects to your DB

// Check if user is logged in
if (!isset($_SESSION['phone'])) {
    echo "❌ Not logged in.";
    exit;
}

// Get user email
$phone = $_SESSION['phone'];
$stmt = $conn->prepare("SELECT email FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    echo "❌ User not found.";
    exit;
}

$email = $user['email'];

// Check resend cooldown
if (isset($_SESSION['otp_sent_time']) && time() - $_SESSION['otp_sent_time'] < 60) {
    echo "⏱️ Please wait before requesting another OTP.";
    exit;
}

// Generate OTP
$otp = rand(100000, 999999);
$_SESSION['otp'] = $otp;
$_SESSION['otp_sent_time'] = time();
$_SESSION['otp_expire'] = time() + 300; // 5 minutes

// Send email
$subject = "Your OTP Code";
$message = "Your OTP code is: $otp";
$headers = "From: no-reply@" . $_SERVER['SERVER_NAME'];

if (mail($email, $subject, $message, $headers)) {
    echo "✅ OTP sent to: $email<br>";
    echo "🔐 Your OTP is: <strong>$otp</strong> (for demo/testing)";
} else {
    echo "❌ Failed to send OTP.";
}
?>