<?php
session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';
include 'db.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Helper functions
function respond_json($data) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data);
    exit;
}
function input_trim($key, $default = '') {
    return isset($_POST[$key]) ? trim($_POST[$key]) : $default;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['action'])) {
    respond_json(['error' => 'Invalid request']);
}

$action = $_POST['action'];

// -----------------------------
// STEP 1: SEND OTP
// -----------------------------
if ($action === 'send_otp') {
    $email        = input_trim('email');
    $username     = input_trim('username');
    $country_code = input_trim('country_code', '+234');
    $phone        = input_trim('phone');
    $password     = $_POST['password'] ?? '';
    $confirm      = $_POST['confirm_password'] ?? '';
    $invite       = input_trim('invite_code');

    if (!$email || !$phone || !$password || !$confirm) {
        respond_json(['error' => 'Please fill all required fields.']);
    }
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        respond_json(['error' => 'Invalid email address.']);
    }
    if ($password !== $confirm) {
        respond_json(['error' => 'Passwords do not match.']);
    }

    $full_phone = $country_code . $phone;

    // Check if phone already exists
    try {
        $check = $conn->prepare("SELECT COUNT(*) FROM users WHERE phone = ?");
        $check->execute([$full_phone]);
        if ($check->fetchColumn() > 0) {
            respond_json(['error' => 'This phone number is already registered.']);
        }
    } catch (Exception $e) {
        respond_json(['error' => 'Database error: ' . $e->getMessage()]);
    }

    // Save registration data temporarily
    $_SESSION['reg_data'] = [
        'username' => $username,
        'email'    => $email,
        'phone'    => $full_phone,
        'password' => password_hash($password, PASSWORD_DEFAULT),
        'invite'   => $invite
    ];

    // Generate OTP
    $otp = random_int(100000, 999999);
    $_SESSION['otp'] = $otp;
    $_SESSION['otp_expire'] = time() + 300; // 5 minutes

    // Send OTP
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'ccccc.new-line-cinema.cc';
        $mail->SMTPAuth = true;
        $mail->Username = '_mainaccount@new-line-cinema.cc';
        $mail->Password = 'Abdul11..Aa123456@';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port = 465;

        $mail->SMTPOptions = [
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true,
            ],
        ];

        $mail->setFrom('no-reply@yourdomain.com', 'New Line Cinema');
        $mail->addAddress($email);
        $mail->isHTML(true);
        $mail->Subject = '🔐 Your One-Time Password (OTP)';
        $mail->Body = "
            <div style='background:#f7f7f7;padding:40px;font-family:Arial;'>
                <div style='max-width:480px;margin:auto;background:#fff;border-radius:8px;box-shadow:0 0 8px rgba(0,0,0,0.1);'>
                    <div style='background:linear-gradient(90deg,#85461E,#caa076);color:#fff;text-align:center;padding:20px;'>
                        <h2>New Line Cinema</h2>
                        <p>Secure Verification Code</p>
                    </div>
                    <div style='padding:30px;text-align:center;'>
                        <p>Hello,</p>
                        <p>Use this code to verify your email:</p>
                        <h1 style='font-size:36px;color:#85461E;'>$otp</h1>
                        <p>This code expires in 5 minutes.</p>
                    </div>
                </div>
            </div>";
        $mail->AltBody = "Your OTP is: $otp";

        $mail->send();
        respond_json(['success' => 'OTP sent successfully!']);
    } catch (Exception $e) {
        respond_json(['error' => 'Mailer Error: ' . $mail->ErrorInfo]);
    }
}

// -----------------------------
// STEP 2: VERIFY OTP & REGISTER
// -----------------------------
if ($action === 'verify_otp') {
    $enteredOtp = input_trim('otp');

    if (!isset($_SESSION['otp'], $_SESSION['otp_expire'], $_SESSION['reg_data'])) {
        respond_json(['error' => 'No OTP session found.']);
    }

    if (time() > $_SESSION['otp_expire']) {
        unset($_SESSION['otp'], $_SESSION['otp_expire'], $_SESSION['reg_data']);
        respond_json(['error' => 'OTP expired.']);
    }

    if ($enteredOtp !== (string)$_SESSION['otp']) {
        respond_json(['error' => 'Invalid OTP.']);
    }

    $data = $_SESSION['reg_data'];
    $invite = $data['invite'] ?? '';
    $my_invite_code = substr(str_shuffle('ABCDEFGHJKLMNPQRSTUVWXYZ23456789'), 0, 6);

    try {
        $stmt = $conn->prepare(
            "INSERT INTO users (username, phone, password, invite_code, invited_by, email)
             VALUES (?, ?, ?, ?, ?, ?)"
        );
        $ok = $stmt->execute([
            $data['username'],
            $data['phone'],
            $data['password'],
            $my_invite_code,
            $invite,
            $data['email']
        ]);

        if ($ok) {
            unset($_SESSION['otp'], $_SESSION['otp_expire'], $_SESSION['reg_data']);
            respond_json(['success' => 'Registration completed successfully.']);
        } else {
            respond_json(['error' => 'Database insert failed.']);
        }
    } catch (Exception $e) {
        respond_json(['error' => 'Database exception: ' . $e->getMessage()]);
    }
}

respond_json(['error' => 'Invalid action.']);