<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include 'db.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");

/// === SEND OTP ===
if (isset($_POST['action']) && $_POST['action'] === 'send_otp' && isset($_POST['email'])) {
    $email = trim($_POST['email']);
    $otp = str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT); // always 6 digits
    $_SESSION['otp'] = $otp;
    $_SESSION['otp_expire'] = time() + 300;
    $_SESSION['otp_email'] = $email;

    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'new-line-cinema.cc';
        $mail->SMTPAuth = true;
        $mail->Username = '_mainaccount@new-line-cinema.cc';
        $mail->Password = '';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port = 465;
        $mail->SMTPOptions = [
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            ]
        ];

        $mail->setFrom('_mainaccount@new-line-cinema.cc', '');
        $mail->addAddress($email); // ✅ Fixed this line (was $user_email)
        $mail->isHTML(true);
        $mail->Subject = 'Your One-Time Password (OTP)';

        // === Stylish HTML Email Template ===
        $mail->Body = '
        <div style="background:#f7f7f7; padding:40px 0; font-family:Arial, sans-serif;">
            <div style="max-width:480px; margin:auto; background:#fff; border-radius:8px; box-shadow:0 0 8px rgba(0,0,0,0.1); overflow:hidden;">
                <div style="background:linear-gradient(90deg,#85461E,#caa076); padding:20px; text-align:center; color:white;">
                    <h2 style="margin:0;"></h2>
                    <p style="margin:5px 0 0; font-size:14px;">Secure Verification Code</p>
                </div>
                <div style="padding:30px; text-align:center; color:#333;">
                    <p style="font-size:16px;">Hello,</p>
                    <p style="font-size:15px; color:#666;">Use the following code to verify your email address:</p>
                    <h1 style="font-size:36px; letter-spacing:5px; margin:20px 0; color:#85461E;">' . $otp . '</h1>
                    <p style="font-size:14px; color:#888;">This code will expire in <b>5 minutes</b>.</p>
                    <a href="#" style="display:inline-block; margin-top:25px; background:#85461E; color:white; text-decoration:none; padding:12px 28px; border-radius:6px; font-size:15px;">Verify Now</a>
                </div>
                <div style="background:#f2f2f2; text-align:center; padding:15px; font-size:12px; color:#999;">
                    © ' . date("Y") . ' . All rights reserved.
                </div>
            </div>
        </div>';

        $mail->AltBody = "Your OTP code is: $otp";
        $mail->send();

        echo json_encode(["success" => "OTP sent successfully!"]);
    } catch (Exception $e) {
        echo json_encode(["error" => "❌ Mailer Error: " . $mail->ErrorInfo]);
    }
    exit;
}


// === CHECK INVITE CODE (AJAX) ===
if (isset($_POST['action']) && $_POST['action'] === 'check_invite' && isset($_POST['code'])) {
    $code = trim($_POST['code']);
    $inviteCheck = $conn->prepare("SELECT id FROM users WHERE invite_code = ?");
    $inviteCheck->execute([$code]);
    echo json_encode(['valid' => (bool)$inviteCheck->fetchColumn()]);
    exit;
}

// === REGISTRATION LOGIC ===
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_POST['action'])) {
    $username       = trim($_POST['username'] ?? "");
    $email          = trim($_POST['email'] ?? "");
    $country_code   = trim($_POST['country_code'] ?? "");
    $phone          = trim($_POST['phone'] ?? "");
    $password       = trim($_POST['password'] ?? "");
    $confirm        = trim($_POST['confirm_password'] ?? "");
    $invite         = trim($_POST['invite_code'] ?? "");
    $otp_entered    = trim($_POST['otp'] ?? "");
    $agree          = isset($_POST['agree']);

    // === Basic Validation ===
    if (!$username || !$email || !$country_code || !$phone || !$password || !$confirm || !$agree || !$invite || !$otp_entered) {
        echo json_encode(['error' => "All fields, including invitation and 6-digit email code, are required."]);
        exit;
    }
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo json_encode(['error' => "Invalid email address."]);
        exit;
    }
    if ($password !== $confirm) {
        echo json_encode(['error' => "Passwords do not match."]);
        exit;
    }
    if (!preg_match('/^\d{6}$/', $otp_entered)) {
        echo json_encode(['error' => "OTP must be exactly 6 digits."]);
        exit;
    }

    // === OTP Must Match Sent Code ===
    if (!isset($_SESSION['otp']) || $otp_entered !== $_SESSION['otp']) {
        echo json_encode(['error' => "Incorrect or expired verification code."]);
        exit;
    }
    if (time() > $_SESSION['otp_expire']) {
        echo json_encode(['error' => "Verification code expired. Please resend."]);
        unset($_SESSION['otp']);
        exit;
    }

    $full_phone = preg_replace('/\D/', '', $country_code . $phone);
    $hashed = password_hash($password, PASSWORD_DEFAULT);
    $my_invite_code = substr(str_shuffle('ABCDEFGHJKLMNPQRSTUVWXYZ23456789'), 0, 6);

    // === Check for duplicates ===
    $check = $conn->prepare("SELECT COUNT(*) FROM users WHERE username = ? OR email = ? OR phone = ?");
    $check->execute([$username, $email, $full_phone]);
    if ($check->fetchColumn() > 0) {
        echo json_encode(['error' => "Username, email, or phone already exists."]);
        exit;
    }

    // === Validate Invitation Code ===
    $inviteCheck = $conn->prepare("SELECT id FROM users WHERE invite_code = ?");
    $inviteCheck->execute([$invite]);
    $invitedBy = $inviteCheck->fetchColumn();
    if (!$invitedBy) {
        echo json_encode(['error' => "Invalid invitation code. Please check and try again."]);
        exit;
    }

    // === Insert User ===
    $stmt = $conn->prepare("
        INSERT INTO users (username, email, phone, password, invite_code, invited_by, created_at)
        VALUES (?, ?, ?, ?, ?, ?, NOW())
    ");
    $inserted = $stmt->execute([
        $username,
        $email,
        $full_phone,
        $hashed,
        $my_invite_code,
        $invitedBy
    ]);

    if ($inserted) {
        unset($_SESSION['otp']);
        unset($_SESSION['otp_expire']);
        echo json_encode(['success' => "Registration successful!"]);
    } else {
        echo json_encode(['error' => "Database error: user not saved."]);
    }
    exit;
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<title>Register</title>
<style>
html, body {
  margin: 0; padding: 0;
  font-family: "Poppins", sans-serif;
  background-color: #000; color: #fff;
  -webkit-text-size-adjust: 100%; text-size-adjust: 100%;
  overscroll-behavior: none;
}

/* --- Toast --- */
.toast {
  position: fixed;
  top: 50%; left: 50%;
  transform: translate(-50%, -50%);
  background: rgba(0,0,0,0.85);
  color: #fff;
  padding: 12px 20px;
  border-radius: 10px;
  font-size: 14px;
  z-index: 2000;
  display: none;
}

/* --- Form layout --- */
.header-image {
  width: 100%;
  height: 220px;
  background: url('/../../back.jpg') center/cover no-repeat;
}
.form-container {
  background: #111;
  border-radius: 25px 25px 0 0;
  padding: 30px 25px 60px;
  margin-top: -30px;
  position: relative;
  z-index: 2;
  box-shadow: 0 -4px 12px rgba(0, 0, 0, 0.4);
}

/* --- Form elements --- */
h2 {
  text-align: center;
  font-size: 22px;
  font-weight: 600;
  margin-bottom: 20px;
}

/* --- All form rows for uniform spacing --- */
.form-row {
  margin-bottom: 15px;
  width: 100%;
}

/* --- Input box --- */
.input-box {
  width: 100%;
  height: 40px;
  background: #2a2a2a;
  border: 1.5px solid #000;
  border-radius: 10px;
  padding: 0 10px;
  font-size: 14px;
  color: #fff;
  box-shadow: 0 2px 6px rgba(255,255,255,0.1);
  box-sizing: border-box;
}
.input-box::placeholder { color: #ccc; }

/* --- Email + OTP inline --- */
.email-wrapper {
  display: flex;
  width: 100%;
}
.email-wrapper input {
  flex: 1;
  height: 40px;
  font-size: 14px;
  padding: 0 10px;
  border: 1.5px solid #000;
  border-radius: 10px 0 0 10px;
  background: #2a2a2a;
  color: #fff;
  box-shadow: 0 2px 6px rgba(255,255,255,0.1);
  outline: none;
}
.email-wrapper button {
  height: 40px;
  font-size: 14px;
  background: linear-gradient(to bottom, #F8D9A0, #FFF4D6);
  color: #111;
  border: none;
  padding: 0 14px;
  border-radius: 0 10px 10px 0;
  font-weight: 500;
  cursor: pointer;
  transition: opacity 0.3s ease;
}
.email-wrapper button:hover { opacity: 0.9; }

.phone-wrapper {
  display: flex;
  width: 100%;
  border: 1.5px solid #000;     /* same as other input-box */
  border-radius: 10px;           /* match other inputs */
  overflow: hidden;              /* ensure button/input corners stay rounded */
  background: #2a2a2a;           /* match input-box background */
  box-shadow: 0 2px 6px rgba(255,255,255,0.1); /* match input-box */
}

.phone-wrapper button#countryBtn {
  background: #2a2a2a;
  color: #fff;
  border: none;                  /* remove inner border, container has it */
  padding: 0 12px;
  height: 40px;
  font-size: 14px;
  line-height: 40px;
  cursor: pointer;
  flex-shrink: 0;
}

.phone-wrapper input[type="text"] {
  flex: 1;
  height: 40px;
  font-size: 14px;
  padding: 0 10px;
  border: none;                  /* remove inner border, container has it */
  background: transparent;       /* inherit container background */
  color: #fff;
  outline: none;
}

/* --- Buttons --- */
.register-button {
  width: 100%;
  height: 40px;
  border: none;
  border-radius: 12px;
  background: linear-gradient(to bottom, #F8D9A0, #FFF4D6);
  color: #111;
  font-weight: 400;
  font-size: 15px;
  cursor: pointer;
  margin-top: 5px;
  transition: opacity 0.3s ease;
}
.register-button:hover { opacity: 0.9; }

/* --- Checkbox & bottom text --- */
.checkbox-text { font-size: 13px; line-height: 1.5; margin-bottom: 10px; }
.checkbox-text label { display: flex; align-items: center; gap: 8px; }
.checkbox-text input[type="checkbox"] { width: 18px; height: 18px; accent-color: #f9b44c; }
.checkbox-text a { color: #f9b44c; text-decoration: none; }

.bottom-text {
  text-align: center;
  font-size: 14px;
  margin-top: 15px;
}
.bottom-text a {
  color: #f9b44c;
  text-decoration: none;
  font-weight: 500;
}

/* --- Country Modal --- */
.country-modal {
  position: fixed;
  left: 0; right: 0; bottom: -100%;
  background: #1a1a1a;
  border-radius: 20px 20px 0 0;
  color: #fff;
  padding: 20px;
  height: 50vh;
  transition: bottom 0.3s ease;
  z-index: 1000;
}
.country-modal.show { bottom: 0; }
.country-modal h3 {
  text-align: center;
  margin-bottom: 15px;
  color: #f9b44c;
}
.country-option {
  padding: 12px 0;
  border-bottom: 1px solid #333;
  cursor: pointer;
  text-align: center;
  font-size: 16px;
}
.country-option:hover { background: #222; }
.country-modal {
  position: fixed;
  left: 0; right: 0; bottom: -100%;
  background: #1a1a1a;
  border-radius: 20px 20px 0 0;
  color: #fff;
  padding: 20px;
  height: 50vh;                  /* height is fine */
  transition: bottom 0.3s ease;
  z-index: 1000;
  overflow-y: auto;              /* ✅ allows vertical scrolling */
  overscroll-behavior: contain;  /* ✅ prevents background scroll */
}
</style>
</head>
<body>

<div class="header-image"></div>

<div class="form-container">
  <h2>Register</h2>
  <form method="POST" id="registerForm" autocomplete="off">

    <div class="form-row">
      <input type="text" name="username" class="input-box" placeholder="Enter username" required>
    </div>

    <div class="form-row email-wrapper">
      <input type="email" name="email" id="email" placeholder="Enter email address" required>
      <button type="button" id="sendOtp">Verification Code</button>
    </div>

    <div class="form-row">
      <input type="text" name="otp" id="otp" class="input-box" placeholder="Enter verification code">
    </div>

    <div class="form-row phone-wrapper">
      <button type="button" id="countryBtn">+44</button>
      <input type="hidden" name="country_code" id="country_code" value="+44">
      <input type="text" name="phone" placeholder="Enter phone number" required>
    </div>

    <div class="form-row">
      <input type="password" name="password" class="input-box" placeholder="Login password" required>
    </div>

    <div class="form-row">
      <input type="password" name="confirm_password" class="input-box" placeholder="Confirm password" required>
    </div>

    <div class="form-row">
      <input type="text" name="invite_code" id="invite_code" class="input-box" maxlength="6" pattern="[A-Za-z0-9]{6}" placeholder="Invitation code" required>
    </div>

    <div class="form-row checkbox-text">
      <label>
        <input type="checkbox" name="agree" required>
        I agree to the <a href="#">User Agreement</a> & <a href="#">Privacy Policy</a>
      </label>
    </div>

    <div class="form-row">
      <button type="submit" class="register-button">Register Now</button>
    </div>

    <div class="bottom-text">Already have an account? <a href="login.php">Login now</a></div>
  </form>
</div>

<!-- Country Modal -->
<div class="country-modal" id="countryModal">
  <h3>Select Country Code</h3>

  <div class="country-option" data-code="+93">🇦🇫 +93 Afghanistan</div>
  <div class="country-option" data-code="+355">🇦🇱 +355 Albania</div>
  <div class="country-option" data-code="+213">🇩🇿 +213 Algeria</div>
  <div class="country-option" data-code="+376">🇦🇩 +376 Andorra</div>
  <div class="country-option" data-code="+244">🇦🇴 +244 Angola</div>
  <div class="country-option" data-code="+54">🇦🇷 +54 Argentina</div>
  <div class="country-option" data-code="+374">🇦🇲 +374 Armenia</div>
  <div class="country-option" data-code="+61">🇦🇺 +61 Australia</div>
  <div class="country-option" data-code="+43">🇦🇹 +43 Austria</div>
  <div class="country-option" data-code="+994">🇦🇿 +994 Azerbaijan</div>

  <div class="country-option" data-code="+973">🇧🇭 +973 Bahrain</div>
  <div class="country-option" data-code="+880">🇧🇩 +880 Bangladesh</div>
  <div class="country-option" data-code="+375">🇧🇾 +375 Belarus</div>
  <div class="country-option" data-code="+32">🇧🇪 +32 Belgium</div>
  <div class="country-option" data-code="+229">🇧🇯 +229 Benin</div>
  <div class="country-option" data-code="+591">🇧🇴 +591 Bolivia</div>
  <div class="country-option" data-code="+387">🇧🇦 +387 Bosnia and Herzegovina</div>
  <div class="country-option" data-code="+267">🇧🇼 +267 Botswana</div>
  <div class="country-option" data-code="+55">🇧🇷 +55 Brazil</div>
  <div class="country-option" data-code="+673">🇧🇳 +673 Brunei</div>
  <div class="country-option" data-code="+359">🇧🇬 +359 Bulgaria</div>
  <div class="country-option" data-code="+226">🇧🇫 +226 Burkina Faso</div>
  <div class="country-option" data-code="+257">🇧🇮 +257 Burundi</div>

  <div class="country-option" data-code="+855">🇰🇭 +855 Cambodia</div>
  <div class="country-option" data-code="+237">🇨🇲 +237 Cameroon</div>
  <div class="country-option" data-code="+1">🇨🇦 +1 Canada</div>
  <div class="country-option" data-code="+56">🇨🇱 +56 Chile</div>
  <div class="country-option" data-code="+86">🇨🇳 +86 China</div>
  <div class="country-option" data-code="+57">🇨🇴 +57 Colombia</div>
  <div class="country-option" data-code="+243">🇨🇩 +243 Congo (DRC)</div>
  <div class="country-option" data-code="+506">🇨🇷 +506 Costa Rica</div>
  <div class="country-option" data-code="+385">🇭🇷 +385 Croatia</div>
  <div class="country-option" data-code="+53">🇨🇺 +53 Cuba</div>
  <div class="country-option" data-code="+357">🇨🇾 +357 Cyprus</div>
  <div class="country-option" data-code="+420">🇨🇿 +420 Czech Republic</div>

  <div class="country-option" data-code="+45">🇩🇰 +45 Denmark</div>
  <div class="country-option" data-code="+253">🇩🇯 +253 Djibouti</div>
  <div class="country-option" data-code="+593">🇪🇨 +593 Ecuador</div>
  <div class="country-option" data-code="+20">🇪🇬 +20 Egypt</div>
  <div class="country-option" data-code="+503">🇸🇻 +503 El Salvador</div>
  <div class="country-option" data-code="+240">🇬🇶 +240 Equatorial Guinea</div>
  <div class="country-option" data-code="+372">🇪🇪 +372 Estonia</div>
  <div class="country-option" data-code="+251">🇪🇹 +251 Ethiopia</div>

  <div class="country-option" data-code="+679">🇫🇯 +679 Fiji</div>
  <div class="country-option" data-code="+358">🇫🇮 +358 Finland</div>
  <div class="country-option" data-code="+33">🇫🇷 +33 France</div>

  <div class="country-option" data-code="+995">🇬🇪 +995 Georgia</div>
  <div class="country-option" data-code="+49">🇩🇪 +49 Germany</div>
  <div class="country-option" data-code="+233">🇬🇭 +233 Ghana</div>
  <div class="country-option" data-code="+30">🇬🇷 +30 Greece</div>
  <div class="country-option" data-code="+502">🇬🇹 +502 Guatemala</div>
  <div class="country-option" data-code="+224">🇬🇳 +224 Guinea</div>
  <div class="country-option" data-code="+592">🇬🇾 +592 Guyana</div>

  <div class="country-option" data-code="+509">🇭🇹 +509 Haiti</div>
  <div class="country-option" data-code="+504">🇭🇳 +504 Honduras</div>
  <div class="country-option" data-code="+852">🇭🇰 +852 Hong Kong</div>
  <div class="country-option" data-code="+36">🇭🇺 +36 Hungary</div>

  <div class="country-option" data-code="+354">🇮🇸 +354 Iceland</div>
  <div class="country-option" data-code="+91">🇮🇳 +91 India</div>
  <div class="country-option" data-code="+62">🇮🇩 +62 Indonesia</div>
  <div class="country-option" data-code="+98">🇮🇷 +98 Iran</div>
  <div class="country-option" data-code="+964">🇮🇶 +964 Iraq</div>
  <div class="country-option" data-code="+353">🇮🇪 +353 Ireland</div>
  <div class="country-option" data-code="+972">🇮🇱 +972 Israel</div>
  <div class="country-option" data-code="+39">🇮🇹 +39 Italy</div>

  <div class="country-option" data-code="+81">🇯🇵 +81 Japan</div>
  <div class="country-option" data-code="+962">🇯🇴 +962 Jordan</div>

  <div class="country-option" data-code="+7">🇰🇿 +7 Kazakhstan</div>
  <div class="country-option" data-code="+254">🇰🇪 +254 Kenya</div>
  <div class="country-option" data-code="+82">🇰🇷 +82 Korea (South)</div>
  <div class="country-option" data-code="+965">🇰🇼 +965 Kuwait</div>
  <div class="country-option" data-code="+996">🇰🇬 +996 Kyrgyzstan</div>

  <div class="country-option" data-code="+856">🇱🇦 +856 Laos</div>
  <div class="country-option" data-code="+371">🇱🇻 +371 Latvia</div>
  <div class="country-option" data-code="+961">🇱🇧 +961 Lebanon</div>
  <div class="country-option" data-code="+231">🇱🇷 +231 Liberia</div>
  <div class="country-option" data-code="+218">🇱🇾 +218 Libya</div>
  <div class="country-option" data-code="+370">🇱🇹 +370 Lithuania</div>
  <div class="country-option" data-code="+352">🇱🇺 +352 Luxembourg</div>

  <div class="country-option" data-code="+853">🇲🇴 +853 Macao</div>
  <div class="country-option" data-code="+389">🇲🇰 +389 Macedonia</div>
  <div class="country-option" data-code="+261">🇲🇬 +261 Madagascar</div>
  <div class="country-option" data-code="+265">🇲🇼 +265 Malawi</div>
  <div class="country-option" data-code="+60">🇲🇾 +60 Malaysia</div>
  <div class="country-option" data-code="+960">🇲🇻 +960 Maldives</div>
  <div class="country-option" data-code="+223">🇲🇱 +223 Mali</div>
  <div class="country-option" data-code="+356">🇲🇹 +356 Malta</div>
  <div class="country-option" data-code="+230">🇲🇺 +230 Mauritius</div>
  <div class="country-option" data-code="+52">🇲🇽 +52 Mexico</div>
  <div class="country-option" data-code="+373">🇲🇩 +373 Moldova</div>
  <div class="country-option" data-code="+377">🇲🇨 +377 Monaco</div>
  <div class="country-option" data-code="+976">🇲🇳 +976 Mongolia</div>
  <div class="country-option" data-code="+212">🇲🇦 +212 Morocco</div>
  <div class="country-option" data-code="+258">🇲🇿 +258 Mozambique</div>

  <div class="country-option" data-code="+95">🇲🇲 +95 Myanmar</div>
  <div class="country-option" data-code="+264">🇳🇦 +264 Namibia</div>
  <div class="country-option" data-code="+977">🇳🇵 +977 Nepal</div>
  <div class="country-option" data-code="+31">🇳🇱 +31 Netherlands</div>
  <div class="country-option" data-code="+64">🇳🇿 +64 New Zealand</div>
  <div class="country-option" data-code="+505">🇳🇮 +505 Nicaragua</div>
  <div class="country-option" data-code="+227">🇳🇪 +227 Niger</div>
  <div class="country-option" data-code="+234">🇳🇬 +234 Nigeria</div>
  <div class="country-option" data-code="+47">🇳🇴 +47 Norway</div>

  <div class="country-option" data-code="+92">🇵🇰 +92 Pakistan</div>
  <div class="country-option" data-code="+970">🇵🇸 +970 Palestine</div>
  <div class="country-option" data-code="+507">🇵🇦 +507 Panama</div>
  <div class="country-option" data-code="+595">🇵🇾 +595 Paraguay</div>
  <div class="country-option" data-code="+51">🇵🇪 +51 Peru</div>
  <div class="country-option" data-code="+63">🇵🇭 +63 Philippines</div>
  <div class="country-option" data-code="+48">🇵🇱 +48 Poland</div>
  <div class="country-option" data-code="+351">🇵🇹 +351 Portugal</div>

  <div class="country-option" data-code="+974">🇶🇦 +974 Qatar</div>

  <div class="country-option" data-code="+40">🇷🇴 +40 Romania</div>
  <div class="country-option" data-code="+7">🇷🇺 +7 Russia</div>
  <div class="country-option" data-code="+250">🇷🇼 +250 Rwanda</div>

  <div class="country-option" data-code="+966">🇸🇦 +966 Saudi Arabia</div>
  <div class="country-option" data-code="+221">🇸🇳 +221 Senegal</div>
  <div class="country-option" data-code="+381">🇷🇸 +381 Serbia</div>
  <div class="country-option" data-code="+65">🇸🇬 +65 Singapore</div>
  <div class="country-option" data-code="+421">🇸🇰 +421 Slovakia</div>
  <div class="country-option" data-code="+386">🇸🇮 +386 Slovenia</div>
  <div class="country-option" data-code="+27">🇿🇦 +27 South Africa</div>
  <div class="country-option" data-code="+82">🇰🇷 +82 South Korea</div>
  <div class="country-option" data-code="+34">🇪🇸 +34 Spain</div>
  <div class="country-option" data-code="+94">🇱🇰 +94 Sri Lanka</div>
  <div class="country-option" data-code="+249">🇸🇩 +249 Sudan</div>
  <div class="country-option" data-code="+46">🇸🇪 +46 Sweden</div>
  <div class="country-option" data-code="+41">🇨🇭 +41 Switzerland</div>
  <div class="country-option" data-code="+963">🇸🇾 +963 Syria</div>

  <div class="country-option" data-code="+886">🇹🇼 +886 Taiwan</div>
  <div class="country-option" data-code="+992">🇹🇯 +992 Tajikistan</div>
  <div class="country-option" data-code="+255">🇹🇿 +255 Tanzania</div>
  <div class="country-option" data-code="+66">🇹🇭 +66 Thailand</div>
  <div class="country-option" data-code="+228">🇹🇬 +228 Togo</div>
  <div class="country-option" data-code="+216">🇹🇳 +216 Tunisia</div>
  <div class="country-option" data-code="+90">🇹🇷 +90 Turkey</div>
  <div class="country-option" data-code="+993">🇹🇲 +993 Turkmenistan</div>
  <div class="country-option" data-code="+256">🇺🇬 +256 Uganda</div>
  <div class="country-option" data-code="+380">🇺🇦 +380 Ukraine</div>
  <div class="country-option" data-code="+971">🇦🇪 +971 United Arab Emirates</div>
  <div class="country-option" data-code="+44">🇬🇧 +44 United Kingdom</div>
  <div class="country-option" data-code="+1">🇺🇸 +1 United States</div>
  <div class="country-option" data-code="+598">🇺🇾 +598 Uruguay</div>
  <div class="country-option" data-code="+998">🇺🇿 +998 Uzbekistan</div>

  <div class="country-option" data-code="+58">🇻🇪 +58 Venezuela</div>
  <div class="country-option" data-code="+84">🇻🇳 +84 Vietnam</div>
  <div class="country-option" data-code="+967">🇾🇪 +967 Yemen</div>
  <div class="country-option" data-code="+260">🇿🇲 +260 Zambia</div>
  <div class="country-option" data-code="+263">🇿🇼 +263 Zimbabwe</div>
</div>

<div class="toast" id="toast"></div>

<script>
// === Toast Function ===
function showToast(message) {
  const toast = document.getElementById("toast");
  toast.innerText = message;
  toast.style.display = "block";
  setTimeout(() => toast.style.display = "none", 2500);
}

// === Send OTP ===
document.getElementById("sendOtp").addEventListener("click", () => {
  const email = document.getElementById("email").value;
  if (!email) return showToast("Enter your email first");

  fetch("", {
    method: "POST",
    headers: {"Content-Type":"application/x-www-form-urlencoded"},
    credentials: "same-origin",
    body: new URLSearchParams({action:"send_otp", email})
  })
  .then(r=>r.json())
  .then(d=> d.success ? showToast(d.success) : showToast(d.error))
  .catch(()=> showToast("Network error, try again"));
});

// === Registration Submit ===
document.getElementById("registerForm").addEventListener("submit", function(e){
  e.preventDefault();
  const formData = new FormData(this);
  const otp = document.getElementById("otp").value.trim();
  if (!otp) return showToast("Please enter OTP first.");
  fetch("", { method: "POST", body: formData })
  .then(r => r.text())
  .then(text => {
    if (text.includes("Registration successful")) {
      showToast("Registration successful!");
      setTimeout(() => { window.location.href = "login.php"; }, 1500);
    } else if (text.includes("Passwords do not match")) showToast("Passwords do not match");
    else if (text.includes("already exists")) showToast("Username, email, or phone already exists");
    else if (text.includes("verify your email")) showToast("Please verify your email first");
    else showToast("Registration failed. Try again.");
  })
  .catch(()=> showToast("Network error. Try again later."));
});

// === Country Modal ===
const modal = document.getElementById('countryModal');
const btn = document.getElementById('countryBtn');
const input = document.getElementById('country_code');
btn.onclick = () => modal.classList.add('show');
document.querySelectorAll('.country-option').forEach(opt => {
  opt.addEventListener('click', () => {
    const code = opt.getAttribute('data-code');
    btn.innerText = code;
    input.value = code;
    modal.classList.remove('show');
  });
});
window.addEventListener('click', (e) => { if (e.target === modal) modal.classList.remove('show'); });

// === Invite Code Autofill ===
const urlParams = new URLSearchParams(window.location.search);
const inviteCode = urlParams.get("invite");
if (inviteCode) {
  const inviteInput = document.getElementById('invite_code');
  inviteInput.value = inviteCode;
  inviteInput.readOnly = true;
}
</script>
</body>
</html>