<?php
// referral_bonus.php
include 'db.php';

// ----------- Referral Bonus after VIP Purchase -------------
function giveReferralBonus($conn, $userPhone, $vipAmount) {
    $stmt = $conn->prepare("SELECT invited_by FROM users WHERE phone = ?");
    $stmt->execute([$userPhone]);
    $referred_by = $stmt->fetchColumn();

    if ($referred_by) {
        $stmt = $conn->prepare("SELECT id FROM users WHERE invite_code = ?");
        $stmt->execute([$referred_by]);
        $referrer_id = $stmt->fetchColumn();

        if ($referrer_id) {
            $bonus = $vipAmount * 0.10;
            $stmt = $conn->prepare("UPDATE users SET team_wallet = team_wallet + ? WHERE id = ?");
            $stmt->execute([$bonus, $referrer_id]);
        }
    }
}

// ----------- Daily Rebate on Income Earned ------------------
function giveDailyRebate($conn, $userPhone, $viewingIncome) {
    // Get the user's invited_by code
    $stmt = $conn->prepare("SELECT invited_by FROM users WHERE phone = ?");
    $stmt->execute([$userPhone]);
    $level1_code = $stmt->fetchColumn();

    // Helper to trace referral chain by invitation_code
    function getReferrerId($conn, $code) {
        $stmt = $conn->prepare("SELECT id FROM users WHERE invite_code = ?");
        $stmt->execute([$code]);
        return $stmt->fetchColumn();
    }

    $levels = [
        1 => 0.06,
        2 => 0.03,
        3 => 0.01
    ];

    $current_code = $level1_code;

    foreach ($levels as $level => $percent) {
        if (!$current_code) break;

        $referrer_id = getReferrerId($conn, $current_code);
        if ($referrer_id) {
            $rebate = $viewingIncome * $percent;
            $stmt = $conn->prepare("UPDATE users SET team_wallet = team_wallet + ? WHERE id = ?");
            $stmt->execute([$rebate, $referrer_id]);

            // Get next level up
            $stmt = $conn->prepare("SELECT invited_by FROM users WHERE invitation_code = ?");
            $stmt->execute([$current_code]);
            $current_code = $stmt->fetchColumn();
        } else {
            break;
        }
    }
}
?>