<?php
session_start();
include 'db.php';
header('Content-Type: application/json');

if (empty($_SESSION['phone'])) {
  echo json_encode(['status' => 'error', 'message' => 'Not logged in']);
  exit;
}

$phone = $_SESSION['phone'];
$vip_id = $_POST['vip_id'] ?? null;

if (!$vip_id) {
  echo json_encode(['status' => 'error', 'message' => 'Missing VIP ID']);
  exit;
}

// ✅ Get user ID
$stmt = $conn->prepare("SELECT id FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user_id = $stmt->fetchColumn();

if (!$user_id) {
  echo json_encode(['status' => 'error', 'message' => 'User not found']);
  exit;
}

// ✅ Get purchase info
$stmt = $conn->prepare("SELECT purchased_at, expire_at FROM purchases WHERE user_id = ? AND vip_product_id = ?");
$stmt->execute([$user_id, $vip_id]);
$purchase = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$purchase) {
  echo json_encode(['status' => 'error', 'message' => 'No VIP purchase found']);
  exit;
}

// ✅ Get valid_days from vip_products
$stmt = $conn->prepare("SELECT valid_days FROM vip_products WHERE id = ?");
$stmt->execute([$vip_id]);
$valid_days = (int)$stmt->fetchColumn();

if (empty($purchase['expire_at']) || $purchase['expire_at'] === '0000-00-00 00:00:00') {
  // If expire_at not set, calculate from purchase date
  $expire_at = date('Y-m-d H:i:s', strtotime($purchase['purchased_at'] . " +{$valid_days} days"));
} else {
  $expire_at = $purchase['expire_at'];
}

// ✅ Subtract 1 day
$new_expire_at = date('Y-m-d H:i:s', strtotime("$expire_at -1 day"));
$today = date('Y-m-d H:i:s');

// ✅ Only update if new_expire_at is still in the future
if (strtotime($new_expire_at) >= strtotime($today)) {
  $update = $conn->prepare("UPDATE purchases SET expire_at = ?, last_valid_update = CURDATE() WHERE user_id = ? AND vip_product_id = ?");
  $update->execute([$new_expire_at, $user_id, $vip_id]);
  echo json_encode(['status' => 'success', 'new_expire_at' => $new_expire_at]);
} else {
  // If reducing makes it expire today or in the past, mark expired
  $update = $conn->prepare("UPDATE purchases SET expire_at = ?, status = 'expired' WHERE user_id = ? AND vip_product_id = ?");
  $update->execute([$new_expire_at, $user_id, $vip_id]);
  echo json_encode(['status' => 'expired', 'message' => 'VIP has now expired']);
}
?>