<?php
session_start();
include 'db.php';

header('Content-Type: application/json');

if (!isset($_SESSION['phone'])) {
    echo json_encode("User not logged in");
    exit();
}

$data = json_decode(file_get_contents("php://input"), true);
$clicked_star = intval($data['star']);

if ($clicked_star < 1) {
    echo json_encode("Invalid star");
    exit();
}

$phone = $_SESSION['phone'];

// Fetch user data
$stmt = $conn->prepare("SELECT id, vip_level, cumulative_withdraw FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
$user_id = $user['id'];
$vip_level = $user['vip_level'];
$current_withdraw = $user['cumulative_withdraw'];

// Get VIP product details
$stmt = $conn->prepare("SELECT daily_earning, watch_times FROM vip_products WHERE id = ?");
$stmt->execute([$vip_level]);
$vip = $stmt->fetch(PDO::FETCH_ASSOC);

$daily_earning = $vip['daily_earning'];
$watch_times = $vip['watch_times'];
$per_click = $daily_earning / $watch_times;

// Get today task
$today = date('Y-m-d');
$stmt = $conn->prepare("SELECT * FROM task_records WHERE user_id = ? AND vip_id = ? AND task_date = ?");
$stmt->execute([$user_id, $vip_level, $today]);
$record = $stmt->fetch(PDO::FETCH_ASSOC);

if ($record) {
    if ($record['stars_clicked'] >= $watch_times) {
        echo json_encode("Daily task already completed.");
        exit();
    }
    if ($clicked_star <= $record['stars_clicked']) {
        echo json_encode("You already earned this star.");
        exit();
    }

    // Update task record
    $stmt = $conn->prepare("UPDATE task_records SET stars_clicked = ? WHERE id = ?");
    $stmt->execute([$clicked_star, $record['id']]);
} else {
    // Create new task record
    $stmt = $conn->prepare("INSERT INTO task_records (user_id, vip_id, task_date, stars_clicked) VALUES (?, ?, ?, ?)");
    $stmt->execute([$user_id, $vip_level, $today, $clicked_star]);
}

// Update user earnings
$new_withdraw = $current_withdraw + $per_click;
$stmt = $conn->prepare("UPDATE users SET cumulative_withdraw = ? WHERE id = ?");
$stmt->execute([$new_withdraw, $user_id]);

echo json_encode("success");