<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
include 'db.php';

if (!isset($_SESSION['phone'])) {
    header("Location: login.php");
    exit;
}

$userId = $_SESSION['id'];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
  if (isset($_POST['vip_id'])) {
    $vipId = intval($_POST['vip_id']);

    // Fetch VIP level using vip_id
    $stmt = $conn->prepare("SELECT level FROM vip_products WHERE id = ?");
    $stmt->execute([$vipId]);
    $vip = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($vip) {
      $vipLevel = $vip['level'];

      try {
        // Insert into purchases table
        $stmt = $conn->prepare("INSERT INTO purchases (user_id, vip_level, purchased_at, vip, vip_id, purchase_date)
                                VALUES (?, ?, NOW(), ?, ?, NOW())");
        $stmt->execute([$userId, $vipLevel, $vipLevel, $vipId]);

        echo "<script>
          alert('VIP purchase successful!');
          window.location.href = '../home.php';
        </script>";
        exit;

      } catch (PDOException $e) {
        if ($e->getCode() == 23000) { // Duplicate entry for user_id + vip_level
          echo "<script>
            alert('You have already purchased this VIP level.');
            window.history.back();
          </script>";
        } else {
          echo "<script>
            alert('Something went wrong. Please try again.');
            window.history.back();
          </script>";
        }
        exit;
      }

    } else {
      echo "<script>
        alert('Invalid VIP product.');
        window.history.back();
      </script>";
      exit;
    }
  }
}
?>