<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
include 'db.php';

if (!isset($_SESSION['phone'])) {
    header("Location: login.php");
    exit();
}

$phone = $_SESSION['phone'];

// Get user info
$stmt = $conn->prepare("SELECT * FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

$user_id = $user['id'];
$invite_code = $user['invite_code'];

// ----------------------
// Referral Tree Setup
// ----------------------
function getReferredUsers($conn, $invitation_code, $exclude_user_id = 0) {
    $stmt = $conn->prepare("SELECT * FROM users WHERE invited_by = ? AND id != ?");
    $stmt->execute([$invitation_code, $exclude_user_id]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Level 1
$level1 = getReferredUsers($conn, $invite_code, $user_id);
$level1_ids = array_column($level1, 'id');

// Level 2
$level2 = [];
$level2_ids = [];
foreach ($level1 as $user1) {
    $sub = getReferredUsers($conn, $user1['invite_code'], $user1['id']);
    $level2 = array_merge($level2, $sub);
    $level2_ids = array_merge($level2_ids, array_column($sub, 'id'));
}

// Level 3
$level3 = [];
$level3_ids = [];
foreach ($level2 as $user2) {
    $sub = getReferredUsers($conn, $user2['invite_code'], $user2['id']);
    $level3 = array_merge($level3, $sub);
    $level3_ids = array_merge($level3_ids, array_column($sub, 'id'));
}

$total_team_members = count($level1) + count($level2) + count($level3);

// ----------------------
// Date and Counters
// ----------------------
$today = date('Y-m-d');
$start_of_week = date('Y-m-d', strtotime('monday this week'));
$last_week = date('Y-m-d', strtotime('-7 days'));

$today_added = $week_added = $last_week_added = 0;

foreach (array_merge($level1, $level2, $level3) as $member) {
    $joined = date('Y-m-d', strtotime($member['created_at']));
    if ($joined === $today) $today_added++;
    if ($joined >= $start_of_week) $week_added++;
    if ($joined >= $last_week && $joined < $start_of_week) $last_week_added++;
}

// ----------------------
// Total & Today Income (what YOU receive)
// ----------------------
$stmt = $conn->prepare("SELECT SUM(amount) FROM referral_bonus WHERE user_id = ?");
$stmt->execute([$user_id]);
$total_income = floatval($stmt->fetchColumn() ?? 0);

$stmt = $conn->prepare("SELECT SUM(amount) FROM referral_bonus WHERE user_id = ? AND DATE(created_at) = ?");
$stmt->execute([$user_id, $today]);
$today_income = floatval($stmt->fetchColumn() ?? 0);

// ----------------------
// Generation Income Calculation
// ----------------------
function sumReferralIncomeFromUsers($conn, $from_user_ids, $today = null) {
    if (empty($from_user_ids)) return 0;
    $in = str_repeat('?,', count($from_user_ids) - 1) . '?';
    $sql = "SELECT SUM(amount) FROM referral_bonus WHERE from_user_id IN ($in)";
    $params = $from_user_ids;
    if ($today) {
        $sql .= " AND DATE(created_at) = ?";
        $params[] = $today;
    }
    $stmt = $conn->prepare($sql);
    $stmt->execute($params);
    return floatval($stmt->fetchColumn() ?? 0);
}

// Level 1
$income_level1 = sumReferralIncomeFromUsers($conn, $level1_ids);
$today_income_level1 = sumReferralIncomeFromUsers($conn, $level1_ids, $today);

// Level 2
$income_level2 = sumReferralIncomeFromUsers($conn, $level2_ids);
$today_income_level2 = sumReferralIncomeFromUsers($conn, $level2_ids, $today);

// Level 3
$income_level3 = sumReferralIncomeFromUsers($conn, $level3_ids);
$today_income_level3 = sumReferralIncomeFromUsers($conn, $level3_ids, $today);

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <!-- ✅ Disable zooming -->
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
  <title>Team</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- ✅ Font Awesome for the icon -->
  <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
  <style>
    /* Universal shine + glow for all white areas */
    .shine {
      color: white;
      font-weight: 700;
      text-shadow: 0 0 6px rgba(255, 255, 255, 0.7),
                   0 0 12px rgba(255, 255, 255, 0.5),
                   0 0 18px rgba(255, 255, 255, 0.3);
      transition: all 0.3s ease-in-out;
    }
    .shine:hover {
      text-shadow: 0 0 10px rgba(255, 255, 255, 0.9),
                   0 0 20px rgba(255, 255, 255, 0.7);
    }

    /* Animated soft glow pulse */
    @keyframes softPulse {
      0%, 100% { box-shadow: 0 0 10px rgba(255,255,255,0.2); }
      50% { box-shadow: 0 0 20px rgba(255,255,255,0.5); }
    }

    .white-card {
      border: 1px solid rgba(255, 255, 255, 0.3);
      background-color: #111;
      animation: softPulse 3s infinite ease-in-out;
    }

    /* Apply your gold color to all zero-like figures */
    .gold-zero {
      color: #F8D9A0 !important;
    }
  </style>
</head>
<body class="bg-black text-white font-sans min-h-screen">
  <div class="max-w-md mx-auto">

    <!-- ✅ Header with link icon -->
    <div class="relative bg-gradient-to-b from-[#F8D9A0] to-[#FFF4D6] text-center py-3 text-lg font-semibold text-black rounded-b-lg shadow-lg">
      Team
      <!-- Small icon in top-right -->
      <a href="team_member_list.php" class="absolute right-3 top-1/2 -translate-y-1/2 text-black hover:text-gray-700">
        <i class="fas fa-users text-xl"></i>
      </a>
    </div>

  </div>

    <!-- ================= TOP COLORED CARDS ================= -->

    <!-- Level Commission -->
<div class="rounded-xl bg-[#111] p-3 m-3 shadow-lg grid grid-cols-3 text-center">
  <div>
    <div class="text-base font-bold text-[#F8D9A0] mb-1">
      <?= number_format($income_level1, 4) ?> USD
    </div>
    <div class="text-sm font-semibold text-white tracking-wide">Level 1 Commission</div>
  </div>
  <div>
    <div class="text-base font-bold text-[#F8D9A0] mb-1">
      <?= number_format($income_level2, 4) ?> USD
    </div>
    <div class="text-sm font-semibold text-white tracking-wide">Level 2 Commission</div>
  </div>
  <div>
    <div class="text-base font-bold text-[#F8D9A0] mb-1">
      <?= number_format($income_level3, 4) ?> USD
    </div>
    <div class="text-sm font-semibold text-white tracking-wide">Level 3 Commission</div>
  </div>
</div>

<!-- Team Info -->
<div class="rounded-xl bg-[#111] p-3 m-3 shadow-lg grid grid-cols-3 text-center">
  <div>
    <div class="text-base font-bold text-[#F8D9A0] mb-1"><?= $total_team_members ?></div>
    <div class="text-sm font-semibold text-white tracking-wide">Cumulative Members</div>
  </div>
  <div>
    <div class="text-base font-bold text-[#F8D9A0] mb-1"><?= number_format($total_income, 4) ?> USD</div>
    <div class="text-sm font-semibold text-white tracking-wide">Total Commission</div>
  </div>
  <div>
    <div class="text-base font-bold text-[#F8D9A0] mb-1"><?= number_format($today_income, 4) ?> USD</div>
    <div class="text-sm font-semibold text-white tracking-wide">Today's Income</div>
  </div>
</div>

<?php
// ✅ Safe initialization to avoid "undefined variable" and "deprecated null" warnings
$today_referral_bonus = isset($today_referral_bonus) && is_numeric($today_referral_bonus) ? $today_referral_bonus : 0;
$total_referral_bonus = isset($total_referral_bonus) && is_numeric($total_referral_bonus) ? $total_referral_bonus : 0;
?>

<!-- Sponsor / Referral Bonus -->
<div class="rounded-xl bg-[#111] p-3 m-3 shadow-lg grid grid-cols-2 text-center">
  <div>
    <div class="text-base font-bold text-[#F8D9A0] mb-1">
      <?= number_format($today_referral_bonus, 4) ?> USD
    </div>
    <div class="text-sm font-semibold text-white tracking-wide">Today's Referral Bonus</div>
  </div>
  <div>
    <div class="text-base font-bold text-[#F8D9A0] mb-1">
      <?= number_format($total_referral_bonus, 4) ?> USD
    </div>
    <div class="text-sm font-semibold text-white tracking-wide">Cumulative Referral Bonus</div>
  </div>
</div>


    <!-- ================= WHITE SHINING CARDS BELOW ================= -->

    <div class="space-y-3 m-3">

      <!-- Level 1 Team -->
<div class="white-card rounded-xl px-4 py-3">
  <div class="flex justify-between items-center">
    <span class="shine">Level 1 Team</span>
    <span class="text-xs shine">(<?= count($level1) ?> / <?= count($level1) ?>)</span>
  </div>
</div>

<!-- Level 2 Team -->
<div class="white-card rounded-xl px-4 py-3">
  <div class="flex justify-between items-center">
    <span class="shine">Level 2 Team</span>
    <span class="text-xs shine">(<?= count($level2) ?> / <?= count($level2) ?>)</span>
  </div>
</div>

<!-- Level 3 Team -->
<div class="white-card rounded-xl px-4 py-3">
  <div class="flex justify-between items-center">
    <span class="shine">Level 3 Team</span>
    <span class="text-xs shine">(<?= count($level3) ?> / <?= count($level3) ?>)</span>
  </div>
</div>



<!-- Total Revenue -->
<div class="relative rounded-xl p-[1px] bg-gradient-to-b from-[#F8D9A0] to-[#FFF4D6] m-3 mt-4 shadow-lg max-w-md mx-auto">
  <div class="bg-[#111] rounded-xl p-3 flex items-center justify-between gap-3">
    
    <!-- Left Side: Chart + Title -->
    <div class="flex flex-col items-center flex-shrink-0">
      <div class="flex items-end gap-1 mb-2">
        <div class="text-sm font-bold text-[#F8D9A0] uppercase">Total Revenue</div>
        <div class="text-base font-semibold text-[#FFF4D6] leading-none"><?= number_format($total_income, 4) ?></div>
      </div>

      <div class="w-24 h-24 relative">
        <svg viewBox="0 0 36 36" class="rotate-[-90deg] drop-shadow-[0_0_8px_rgba(255,215,0,0.6)]">
          <!-- Orange Segment -->
          <circle cx="18" cy="18" r="15.9155" fill="none" stroke="#FFA500" stroke-width="4" stroke-dasharray="33,67" stroke-dashoffset="0"></circle>
          <!-- Purple Segment -->
          <circle cx="18" cy="18" r="15.9155" fill="none" stroke="#A855F7" stroke-width="4" stroke-dasharray="33,67" stroke-dashoffset="33"></circle>
          <!-- Yellow Segment -->
          <circle cx="18" cy="18" r="15.9155" fill="none" stroke="#FFD700" stroke-width="4" stroke-dasharray="34,66" stroke-dashoffset="66"></circle>
          <!-- Inner Circle -->
          <circle cx="18" cy="18" r="11" fill="#111" stroke="none"></circle>
        </svg>
      </div>
    </div>

    <!-- Right Side: Breakdown Info -->
    <div class="text-left space-y-1 flex-1">
      <div class="text-xs space-y-1 leading-tight">
        <div><span class="text-[#FFA500] font-bold">●</span> Task revenue (<span class="gold-zero">0.0000</span>)</div>
        <div><span class="text-[#A855F7] font-bold">●</span> Commission (<span class="text-[#F8D9A0]"><?= number_format($total_income, 4) ?></span>)</div>
        <div><span class="text-[#FFD700] font-bold">●</span> Sponsor (<span class="gold-zero">0.0000</span>)</div>
      </div>
    </div>

  </div>
</div>

  <?php include 'bottom_nav.php'; ?>
</body>
</html>