<?php
session_start();
include 'db.php';

$phone = $_SESSION['phone'] ?? '';
if (!$phone) {
    header("Location: login.php");
    exit();
}

// ✅ Fetch user actual NLC from `users` table
$user_stmt = $conn->prepare("SELECT nlc_points FROM users WHERE phone = ?");
$user_stmt->execute([$phone]);
$user = $user_stmt->fetch(PDO::FETCH_ASSOC);

$nlc_balance = $user['nlc_points'] ?? 0;

// ✅ Fetch all NLC transaction history
$stmt = $conn->prepare("SELECT * FROM nlc_point_exchanges WHERE phone = ? ORDER BY exchanged_at DESC");
$stmt->execute([$phone]);
$history = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>NLC Coin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

    <style>
        body {
            background-color: #000;
            color: #fff;
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding-bottom: 40px;
        }

        /* Header */
        .header {
            background: #0b0b0b;
            color: #FFD76E;
            text-align: center;
            padding: 16px 0;
            font-size: 18px;
            font-weight: 600;
            border-bottom: 1px solid #1a1a1a;
        }

        /* Wallet Card */
        .wallet-card {
            background: linear-gradient(180deg, #FFFFFF 0%, #FFEAB6 100%);
            border-radius: 12px;
            margin: 20px;
            padding: 18px 0;
            display: flex;
            justify-content: center;
            align-items: center;
            color: #000;
            text-align: center;
            flex-direction: column;
            box-shadow: 0 0 8px rgba(0,0,0,0.4);
        }

        .wallet-icon {
            background: #000;
            width: 45px;
            height: 45px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 8px;
            box-shadow: 0 0 6px rgba(0,0,0,0.4);
        }

        .wallet-icon i {
            color: #FFD76E;
            font-size: 20px;
        }

        .wallet-card p {
            margin: 2px 0;
            font-size: 0.9rem;
            font-weight: 600;
        }

        .wallet-card h2 {
            margin: 4px 0;
            font-size: 1.6rem;
            font-weight: 700;
        }

        /* Transaction Section */
        .section-header {
            display: flex;
            justify-content: space-between;
            padding: 10px 18px;
            font-size: 13px;
            color: #aaa;
            border-bottom: 1px solid #1a1a1a;
        }

        .entry {
            background: #111;
            padding: 15px 18px;
            border-bottom: 1px solid #1a1a1a;
        }

        .entry-title {
            font-weight: 600;
            font-size: 15px;
            color: #fff;
        }

        .entry small {
            color: #888;
            font-size: 12px;
            display: block;
            margin-top: 4px;
        }

        .entry .amount {
            float: right;
            font-weight: bold;
            font-size: 15px;
        }

        .positive { color: #00e676; }
        .negative { color: #ff5252; }

        .no-records {
            text-align: center;
            color: #666;
            margin-top: 50px;
        }

        .back-link {
            display: block;
            text-align: center;
            color: #FFD76E;
            margin-top: 20px;
            text-decoration: none;
        }

        .back-link:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>

<!-- Header -->
<div class="header">point Record</div>

<!-- Wallet Card -->
<div class="wallet-card">
    <div class="wallet-icon"><i class="fa-solid fa-shuffle"></i></div>
    <p>point Total</p>
    <h2><?= number_format($nlc_balance, 2) ?></h2>
</div>

<!-- Transaction Details -->
<div class="section-header">
    <span>point Details</span>
    <span>All ▾</span>
</div>

<?php if (!$history): ?>
    <div class="no-records">No records found.</div>
<?php else: ?>
    <?php foreach ($history as $entry): 
        $isEarning = ($entry['usd_value'] == 0);
        $amount = $entry['points_used'];
    ?>
    <div class="entry completed">
        <div class="entry-title">
            <?= $isEarning ? 'Activity Award' : 'Exchange' ?>
            <span class="amount <?= $isEarning ? 'positive' : 'negative' ?>">
                <?= $isEarning ? '+' . $amount . ' NLC' : '-' . $amount . ' NLC' ?>
            </span>
        </div>
        <small><?= date("Y-m-d H:i:s", strtotime($entry['exchanged_at'])) ?> &nbsp; completed</small>
    </div>
    <?php endforeach; ?>
<?php endif; ?>

<a class="back-link" href=""></a>

</body>
</html>