<?php    
// Enable error reporting for development    
ini_set('display_errors', 1);    
ini_set('display_startup_errors', 1);    
error_reporting(E_ALL);    
    
session_start();
include 'db.php';

if (!isset($_SESSION['phone'])) {
    header("Location: login.php");
    exit();
}

$phone = $_SESSION['phone'];

// Get amount and network from previous page
$amount  = isset($_GET['amount']) ? floatval($_GET['amount']) : 0;
$network = isset($_GET['network']) ? $_GET['network'] : "TRC20";

// 🔐 Permanent wallet addresses (cannot be changed by user)
define("WALLET_TRC20", "TCGZLzmAWoWrEeuw7tMP2rsfXayZCfdf5G");
define("WALLET_ERC20", "TCGZLzmAWoWrEeuw7tMP2rsfXayZCfdf5G");
define("WALLET_BEP20", "0x02c4fe7424da366fdf236ff8ef89e43ca6dda679");

// Map networks to permanent addresses
$wallets = [
    "TRC20" => WALLET_TRC20,
    "ERC20" => WALLET_ERC20,
    "BEP20" => WALLET_BEP20
];

// Always pick the permanent wallet for selected network
$walletAddress = $wallets[$network] ?? WALLET_TRC20;

$success = "";
$error   = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $txid = trim($_POST['txid'] ?? '');

    if (empty($txid)) {
        $error = "Please enter the transaction ID (TXID).";
    }

    if (empty($error)) {
        // Insert into recharge_records table as pending
        $stmt = $conn->prepare("INSERT INTO recharge_records 
            (phone, amount, payment_method, network, status, txid, created_at) 
            VALUES (?, ?, ?, ?, 'pending', ?, NOW())");
        $stmt->execute([$phone, $amount, 'Manual', $network, $txid]);
        $success = "Deposit submitted successfully";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manual Deposit</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

<style>
html, body {
    margin:0; 
    font-family:sans-serif; 
    background:#000; 
    color:white; 
    touch-action:manipulation; 
    overscroll-behavior:none;
}
body {
    -webkit-text-size-adjust: 100%; 
}
.header { display:flex; align-items:center; padding:15px; background:#111; font-size:18px; font-weight:bold; }
.header span { margin-left:120px; }
.container { padding:20px; }
.network-box { background:#111; padding:20px; border-radius:12px; text-align:center; }
.network-label { font-size:14px; margin-bottom:8px; }
.network { display:inline-flex; align-items:center; gap:6px; background:#1c1c1c; padding:6px 12px; border-radius:6px; font-size:10px; }
.network img { width:20px; height:12px; }
.qr { margin:20px 0; }
.qr img { width:200px; border-radius:10px; }
.deposit-box { background:#1c1c1c; padding:12px; border-radius:6px; display:flex; justify-content:space-between; align-items:center; font-size:13px; margin-bottom:15px; word-break:break-all; }
.copy-btn { color:#bb86fc; font-weight:bold; cursor:pointer; }
.reminder { background:#111; padding:15px; border-radius:8px; font-size:12px; line-height:1.6; }
.reminder h4 { margin:0 0 8px 0; font-weight:bold; color:#ffc107; font-size:13px; }
.reminder ol { padding-left:18px; margin:0; font-weight:normal; }
form { margin-top:20px; }
input[type="text"], button { 
    width:100%; 
    padding:12px; 
    margin-top:12px; 
    border-radius:6px; 
    border:none; 
    font-size:15px; 
    box-sizing:border-box; 
}
button { background:#caa076; color:white; cursor:pointer; font-weight:bold; }
#error-msg { color:red; margin:10px 0; }
#toast { 
    position: fixed; 
    bottom: 20px; 
    left: 50%; 
    transform: translateX(-50%); 
    background: rgba(0,0,0,0.85); 
    color: white; 
    padding: 12px 20px; 
    border-radius: 6px; 
    font-size: 14px; 
    opacity: 0; 
    transition: opacity 0.5s ease; 
    z-index: 9999; 
    pointer-events: none;
}
</style>
</head>
<body>

<!-- Header -->
<div class="header">← <span>Asset Deposit</span></div>

<div class="container">

  <div class="network-box">
      <div class="network-label">Network</div>
      <div class="network">
        <img src="/../../../logoo.png" alt="Network">
        <?= htmlspecialchars($network) ?>
      </div>
      <div class="qr">
        <img src="'/../../../logoo.png" alt="QR Code">
      </div>
  </div>

  <div class="deposit-box">
    <span><?= htmlspecialchars($walletAddress) ?></span>
    <span class="copy-btn" onclick="copyAddress('<?= htmlspecialchars($walletAddress) ?>')">Copy</span>
  </div>

  <p>Send <strong><?= number_format($amount,2) ?> USDT</strong> to the wallet above.</p>

  <?php if($error): ?>
      <div id="error-msg"><?= $error ?></div>
  <?php endif; ?>

  <!-- Deposit Form -->
  <form method="POST">
      <input type="text" name="txid" placeholder="Enter TXID after sending" required>
      <button type="submit">Submit Deposit</button>
  </form>

  <!-- Reminder -->
  <div class="reminder">
    <h4>⚠ Warm reminder</h4>
    <ol>
      <li>The minimum deposit amount is 1 USDT, less than the minimum deposit amount cannot be credited to the account.</li>
      <li>Please do not deposit non-USDT assets to the above address, otherwise it will not be retrieved.</li>
      <li>Your deposit address is fixed and will not change.</li>
    </ol>
  </div>

</div>

<!-- Toast -->
<div id="toast"></div>

<script>
function showToast(message) {
    const toast = document.getElementById('toast');
    toast.textContent = message;
    toast.style.opacity = '1';
    setTimeout(() => { toast.style.opacity = '0'; }, 2000);
}
function copyAddress(address) {
    navigator.clipboard.writeText(address).then(() => {
        showToast("Deposit address copied!");
    });
}
</script>

<?php if($success): ?>
<script>
    showToast("<?= $success ?>");
    setTimeout(() => { window.location.href = '/../../../asset.php'; }, 2500);
</script>
<?php endif; ?>

</body>
</html>
