<?php
session_start();
include 'db.php';

if (!isset($_SESSION['phone'])) {
  header("Location: login.php");
  exit();
}

$phone = $_SESSION['phone'];

// Fetch wallet addresses for user
$stmt = $conn->prepare("SELECT currency, network, address FROM wallets WHERE phone = ?");
$stmt->execute([$phone]);
$wallets = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Map addresses for JS
$walletMap = [];
foreach ($wallets as $w) {
  $walletMap[$w['currency'].' ('.$w['network'].')'] = $w['address'];
}

// Default values
$defaultCurrency = array_key_first($walletMap) ?? 'USDT (TRC20)';
$defaultAddress = $walletMap[$defaultCurrency] ?? 'Not set';
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Asset Deposit</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body { background:#000; color:#fff; font-family:'Poppins',sans-serif; margin:0; }
    .topbar { display:flex; align-items:center; padding:15px; font-size:18px; }
    .topbar a { color:#fff; text-decoration:none; font-size:22px; }
    .topbar span { flex:1; text-align:center; }

    .qr-box { text-align:center; margin-top:20px; }
    .qr-box img { width:220px; height:220px; background:#fff; border-radius:12px; }

    .wallet-box {
      background:#111; margin:20px; padding:20px;
      border-radius:12px; color:#ddd;
    }
    .wallet-box label { font-size:14px; color:#999; display:block; margin-bottom:8px; }
    .select-btn {
      display:flex; align-items:center; justify-content:space-between;
      width:100%; background:#1a1a1a; color:#fff;
      border:none; border-radius:10px; padding:14px;
      font-size:15px; cursor:pointer;
    }
    .address-box {
      display:flex; align-items:center; justify-content:space-between;
      margin-top:10px; background:#1a1a1a;
      padding:14px; border-radius:10px; word-break:break-all;
      font-size:14px;
    }
    .copy-btn {
      background:none; border:none; color:#FFD86E; cursor:pointer;
      font-size:16px;
    }

    .warning {
      margin:20px; font-size:13px; color:#bbb;
      background:#111; padding:15px; border-radius:12px;
    }
    .warning h4 { color:#FFD86E; margin-bottom:8px; font-size:14px; }

    /* Modal bottom pop */
    .modal {
      position:fixed; left:0; right:0; bottom:-100%;
      background:#000; color:#fff; border-radius:16px 16px 0 0;
      transition:bottom 0.4s ease; padding:20px; z-index:1000;
    }
    .modal.show { bottom:0; }
    .modal h3 { text-align:center; margin-bottom:15px; }
    .modal button.option {
      width:100%; background:#111; color:#fff;
      border:none; padding:14px; margin:5px 0;
      border-radius:10px; cursor:pointer; font-size:15px;
    }

    /* Toast */
    .toast {
      position:fixed; top:50%; left:50%; transform:translate(-50%,-50%);
      background:rgba(0,0,0,0.85); padding:12px 20px;
      border-radius:8px; font-size:14px; opacity:0;
      transition:opacity 0.3s; z-index:9999;
    }
    .toast.show { opacity:1; }
  </style>
</head>
<body>

<div class="topbar">
  <a href="mine.php">←</a>
  <span>Asset Deposit</span>
</div>

<div class="qr-box">
  <img id="qrImage" src="https://api.qrserver.com/v1/create-qr-code/?size=220x220&data=<?= urlencode($defaultAddress) ?>" alt="QR Code">
</div>

<div class="wallet-box">
  <label>SELECT CURRENCY</label>
  <button type="button" id="currencyBtn" class="select-btn" onclick="openModal()"> 
    <span id="currencyText"><?= htmlspecialchars($defaultCurrency) ?></span> 
    <span>›</span>
  </button>

  <label style="margin-top:20px;">DEPOSIT ADDRESS</label>
  <div class="address-box">
    <span id="depositAddress"><?= htmlspecialchars($defaultAddress) ?></span>
    <button class="copy-btn" onclick="copyAddress()">📋</button>
  </div>
</div>

<div class="warning">
  <h4>⚠️ Warm reminder</h4>
  <p>1. The minimum recharge amount is US$10.</p>
  <p>2. Please do not recharge non-USDT assets to the above address, otherwise it will not be retrieved.</p>
  <p>3. Your recharge address will not change frequently. If there is any change, we will notify you through the APP announcement.</p>
</div>

<!-- Bottom Modal -->
<div id="modal" class="modal">
  <h3>Select Currency</h3>
  <div id="modalContent"></div>
</div>

<div id="toast" class="toast"></div>

<script>
const walletMap = <?= json_encode($walletMap) ?>;

function openModal(){
  const modal=document.getElementById('modal');
  const content=document.getElementById('modalContent');
  content.innerHTML='';
  Object.keys(walletMap).forEach(opt=>{
    const btn=document.createElement('button');
    btn.textContent=opt;
    btn.className='option';
    btn.onclick=()=>selectCurrency(opt);
    content.appendChild(btn);
  });
  modal.classList.add('show');
}

function selectCurrency(currency){
  const modal=document.getElementById('modal');
  document.getElementById('currencyText').textContent=currency;
  const address=walletMap[currency]||'';
  document.getElementById('depositAddress').textContent=address;
  document.getElementById('qrImage').src="https://api.qrserver.com/v1/create-qr-code/?size=220x220&data="+encodeURIComponent(address);
  modal.classList.remove('show');
}

function copyAddress(){
  const addr=document.getElementById('depositAddress').textContent;
  navigator.clipboard.writeText(addr).then(()=>{
    showToast("Copied!");
  });
}

function showToast(msg){
  const toast=document.getElementById('toast');
  toast.textContent=msg;
  toast.classList.add('show');
  setTimeout(()=>toast.classList.remove('show'),2000);
}
</script>
</body>
</html>