<?php
$config = include 'kbpay_config.php';

$order_id = 'ORD' . time(); // Unique order ID
$amount   = 10.00; // Amount in USDT
$currency = 'USDT'; // Coin type

$payload = [
    'merchant_no'   => $config['merchant_no'],
    'order_no'      => $order_id,
    'amount'        => number_format($amount, 2, '.', ''),
    'pay_currency'  => $currency,
    'notify_url'    => $config['notify_url'],
    'return_url'    => $config['return_url'],
    'user_name'     => 'User_' . rand(1000, 9999),
    'sign'          => '', // Placeholder, sign will be generated
];

// Create sign string
$sign_string = $payload['merchant_no'] . $payload['order_no'] . $payload['amount'] . $payload['pay_currency'] . $config['api_key'];
$payload['sign'] = md5($sign_string);

// Send the request to KBPay
$ch = curl_init($config['gateway_url']);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));
$response = curl_exec($ch);
curl_close($ch);

// Decode response and redirect
$result = json_decode($response, true);

if ($result && $result['code'] == 0) {
    header("Location: " . $result['data']['pay_url']);
    exit();
} else {
    echo "Error: " . ($result['msg'] ?? 'Unknown error');
}