<?php
include 'db.php';

$input = file_get_contents("php://input");
$data = json_decode($input, true);

// Optional: log for debugging
file_put_contents("oxapay_log.txt", date("Y-m-d H:i:s") . "\n" . print_r($data, true) . "\n", FILE_APPEND);

if ($data && isset($data['status']) && $data['status'] === 'paid') {
    $orderId = $data['order_id'];
    $amount = $data['amount'];
    $email = $data['email'];
    $phone = explode('@', $email)[0];

    // Prevent duplicate transactions
    $check = $conn->prepare("SELECT COUNT(*) FROM transactions WHERE order_id = ?");
    $check->execute([$orderId]);
    if ($check->fetchColumn() == 0) {
        $stmt = $conn->prepare("UPDATE users SET cumulative_recharge = cumulative_recharge + ?, electronic_wallet = electronic_wallet + ? WHERE phone = ?");
$stmt->execute([$amount, $amount, $phone]);

        $stmt = $conn->prepare("INSERT INTO transactions (phone, amount, method, status, order_id, created_at)
                                VALUES (?, ?, 'oxapay', 'completed', ?, NOW())");
        $stmt->execute([$phone, $amount, $orderId]);
    }
}

http_response_code(200);
echo "OK";