<?php
session_start();
include 'db.php';

if (!isset($_SESSION['phone'])) {
    header("Location: login.php");
    exit();
}

$phone = $_SESSION['phone'];

// ✅ Fetch successful recharges
$stmt1 = $conn->prepare("
    SELECT 'Recharge Successful' AS type, amount, created_at 
    FROM recharge_records 
    WHERE phone = ? AND status = 'success'
");

// ✅ Fetch successful withdrawals
$stmt2 = $conn->prepare("
    SELECT 'Withdrawal Successful' AS type, amount, created_at 
    FROM withdrawals 
    WHERE phone = ? AND status = 'success'
");

$stmt1->execute([$phone]);
$stmt2->execute([$phone]);

$recharges = $stmt1->fetchAll(PDO::FETCH_ASSOC);
$withdrawals = $stmt2->fetchAll(PDO::FETCH_ASSOC);

// ✅ Merge and sort by date (latest first)
$notifications = array_merge($recharges, $withdrawals);
usort($notifications, function($a, $b) {
    return strtotime($b['created_at']) - strtotime($a['created_at']);
});
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Notifications</title>
<style>
  body {
    margin: 0;
    padding: 0;
    background-color: #000;
    font-family: 'Poppins', sans-serif;
    color: #fff;
  }

  .header {
    background: #111;
    color: #FFD700;
    text-align: center;
    padding: 15px;
    font-size: 20px;
    font-weight: bold;
    border-bottom: 2px solid #FFD700;
    letter-spacing: 1px;
  }

  .container {
    padding: 20px;
    max-width: 800px;
    margin: 0 auto;
  }

  .notification-card {
    position: relative;
    background: rgba(255, 215, 0, 0.1);
    border-radius: 12px;
    padding: 15px 20px;
    margin-bottom: 15px;
    box-shadow: 0 0 15px rgba(255, 215, 0, 0.4);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 215, 0, 0.3);
    transition: 0.3s ease;
  }

  .notification-card:hover {
    box-shadow: 0 0 25px rgba(255, 215, 0, 0.8);
    transform: translateY(-3px);
  }

  .notification-title {
    font-size: 16px;
    font-weight: bold;
    color: #FFD700;
  }

  .notification-amount {
    font-size: 15px;
    color: #fff;
    margin-top: 6px;
  }

  .notification-time {
    font-size: 13px;
    color: #aaa;
    text-align: right;
    margin-top: 8px;
  }

  .no-data {
    text-align: center;
    color: #777;
    font-size: 15px;
    margin-top: 30px;
  }

  @keyframes glow {
    0% { box-shadow: 0 0 10px rgba(255, 215, 0, 0.4); }
    50% { box-shadow: 0 0 25px rgba(255, 215, 0, 1); }
    100% { box-shadow: 0 0 10px rgba(255, 215, 0, 0.4); }
  }

  .glow {
    animation: glow 2s infinite;
  }
</style>
</head>
<body>

<div class="header">Notifications</div>

<div class="container">
  <?php if (empty($notifications)): ?>
    <div class="no-data">No notifications yet.</div>
  <?php else: ?>
    <?php foreach ($notifications as $n): ?>
      <div class="notification-card glow">
        <div class="notification-title"><?php echo htmlspecialchars($n['type']); ?></div>
        <div class="notification-amount">Amount: ₦<?php echo number_format($n['amount'], 2); ?></div>
        <div class="notification-time"><?php echo date("d M Y, h:i A", strtotime($n['created_at'])); ?></div>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</div>

</body>
</html>