<?php
session_start();
include 'db.php';

$phone = $_SESSION['phone'] ?? '';
if (!$phone) {
    header("Location: login.php");
    exit();
}

// Fetch NLC transactions (earnings + exchanges)
$stmt = $conn->prepare("SELECT * FROM nlc_point_exchanges WHERE phone = ? ORDER BY exchanged_at DESC");
$stmt->execute([$phone]);
$history = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Calculate total NLC balance
$total_stmt = $conn->prepare("SELECT SUM(CASE WHEN usd_value = 0 THEN points_used ELSE -points_used END) AS total FROM nlc_point_exchanges WHERE phone = ?");
$total_stmt->execute([$phone]);
$total_balance = $total_stmt->fetchColumn() ?? 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>NLC Coin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <style>
        body {
            background-color: #000;
            color: #fff;
            font-family: Arial, sans-serif;
            margin: 0;
            padding-bottom: 40px;
        }

        /* Header section */
        .header {
            background-color: #0b0b0b;
            color: #00e676;
            text-align: center;
            padding: 15px 0;
            font-weight: bold;
            font-size: 18px;
        }

        /* Total card - matches your screenshot */
        .total-card {
            background: linear-gradient(90deg, #9be15d, #00e3ae);
            color: #000;
            border-radius: 20px;
            margin: 15px;
            padding: 25px 20px;
            text-align: center;
            box-shadow: 0 0 8px rgba(0, 0, 0, 0.4);
        }

        .total-card .label {
            font-size: 14px;
            opacity: 0.9;
        }

        .total-card .amount {
            font-size: 42px;
            font-weight: bold;
            margin-top: 5px;
        }

        /* Table/records heading row */
        .details-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 18px;
            font-size: 13px;
            color: #999;
        }

        .details-header span {
            cursor: pointer;
        }

        /* Record entry box */
        .entry {
            background: #111;
            padding: 15px 20px;
            border-bottom: 1px solid #222;
        }

        .entry-title {
            font-weight: bold;
            font-size: 15px;
            color: #fff;
        }

        .entry small {
            color: #888;
            font-size: 12px;
            display: block;
            margin-top: 4px;
        }

        .entry .amount {
            float: right;
            font-weight: bold;
            font-size: 15px;
        }

        .positive {
            color: #00e676;
        }

        .negative {
            color: #ff5252;
        }

        .no-records {
            text-align: center;
            color: #666;
            margin-top: 50px;
        }

        .back-link {
            display: block;
            text-align: center;
            color: #00e676;
            margin-top: 20px;
            text-decoration: none;
        }

        .back-link:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>

<!-- Header -->
<div class="header">NLC Coin</div>

<!-- Total Card -->
<div class="total-card">
    <div class="label">NLC Coin Total</div>
    <div class="amount"><?= number_format($total_balance, 2) ?></div>
</div>

<!-- Record Header (like “CERO Coin Details”) -->
<div class="details-header">
    <span>NLC Coin Details</span>
    <span>All ▾</span>
</div>

<?php if (!$history): ?>
    <div class="no-records">No records found.</div>
<?php else: ?>
    <?php foreach ($history as $entry): 
        $isEarning = ($entry['usd_value'] == 0);
        $amount = $entry['points_used'];
    ?>
    <div class="entry completed">
        <div class="entry-title">
            <?= $isEarning ? 'Activity Award' : 'Exchange' ?>
            <span class="amount <?= $isEarning ? 'positive' : 'negative' ?>">
                <?= $isEarning ? '+' . $amount . ' NLC' : '-' . $amount . ' NLC' ?>
            </span>
        </div>
        <small><?= date("Y-m-d H:i:s", strtotime($entry['exchanged_at'])) ?> &nbsp; completed</small>
    </div>
    <?php endforeach; ?>
<?php endif; ?>

<a class="back-link" href="nlc_points.php">← Back to NLC</a>

</body>
</html>