<?php
session_start();
include 'db.php';

$phone = $_SESSION['phone'] ?? '';
if (!$phone) {
    header("Location: login.php");
    exit();
}

// Get user balance
$stmt = $conn->prepare("SELECT nlc_points, flexible_wallet FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
$nlc = $user['nlc_points'];
$wallet = $user['flexible_wallet'];

// Handle exchange via AJAX
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['points'], $_POST['reward'])) {
    $points = intval($_POST['points']);
    $reward = floatval($_POST['reward']);

    // Always fetch latest data
    $stmt = $conn->prepare("SELECT nlc_points, flexible_wallet FROM users WHERE phone = ?");
    $stmt->execute([$phone]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    $nlc = $user['nlc_points'];
    $wallet = $user['flexible_wallet'];

    // Allow exchange if user has enough NLC and at least 50
    if ($nlc >= $points && $points >= 50) {
        $new_nlc = $nlc - $points;
        $new_wallet = $wallet + $reward;

        $update = $conn->prepare("UPDATE users SET nlc_points = ?, flexible_wallet = ? WHERE phone = ?");
        $update->execute([$new_nlc, $new_wallet, $phone]);

        $log = $conn->prepare("INSERT INTO nlc_point_exchanges (phone, points_used, usd_value, exchanged_at) VALUES (?, ?, ?, NOW())");
        $log->execute([$phone, $points, $reward]);

        echo json_encode(["success" => true, "new_nlc" => $new_nlc]);
        exit();
    } else {
        echo json_encode(["success" => false, "msg" => "Not enough NLC to exchange"]);
        exit();
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>My NLC</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <style>
        body { background-color: #111; font-family: Arial, sans-serif; margin: 0; padding: 0; color: #fff; }
        .header { padding: 20px; background: #1c1c1c; text-align: center; font-size: 20px; font-weight: bold; }
        .total-box { background: #222; padding: 20px; border-radius: 10px; margin: 20px; display: flex; justify-content: space-between; align-items: center; }
        .coin-icon { font-size: 40px; margin-right: 15px; color: #caa076; }
        .exchange-section { margin: 0 20px 20px 20px; }
        .exchange-box { background: #1c1c1c; padding: 15px; border-radius: 10px; margin-bottom: 10px; display: flex; justify-content: space-between; align-items: center; }
        .exchange-box button { background-color: #caa076; color: #fff; border: none; padding: 8px 14px; border-radius: 6px; cursor: pointer; }
        .exchange-box button:disabled { background: #555; cursor: not-allowed; }
        #toast { visibility: hidden; min-width: 120px; background-color: black; color: #fff; text-align: center; border-radius: 8px; padding: 10px; position: fixed; top: 40%; left: 50%; transform: translate(-50%, -50%); z-index: 1000; font-size: 16px; }
        #toast.show { visibility: visible; animation: fadein 0.5s, fadeout 0.5s 2s; }
        @keyframes fadein { from {opacity: 0;} to {opacity: 1;} }
        @keyframes fadeout { from {opacity: 1;} to {opacity: 0;} }
    </style>
</head>
<body>

<div class="header">My NLC</div>

<div class="total-box">
    <div class="left" style="display:flex; align-items:center;">
        <div class="coin-icon">🪙</div>
        <div>
            <div style="display:flex; justify-content:space-between; align-items:center; width:100%;">
                <span>Total NLC</span>
                <a href="nlc_points_record.php" style="color:#caa076; font-size:14px; text-decoration:none; margin-left:15px;">View Details</a>
            </div>
            <h2 id="nlcBalance" style="margin:5px 0 0 0;"><?= $nlc ?></h2>
        </div>
    </div>
</div>

<div class="exchange-section">
<?php
$rewards = [
    50 => 10,
    100 => 20,
    300 => 80,
    500 => 160,
    3000 => 300
];
foreach ($rewards as $points => $usd):
    // Only enable exchange once user has >=50 points and enough for the current tier
    $disabled = ($nlc < 50 || $nlc < $points) ? 'disabled' : '';
?>
    <div class="exchange-box">
        <div class="left">
            <?php if ($points == 3000): ?>
                Collect over <?= $points ?> coins and exchange for the latest version of iPhone
            <?php else: ?>
                Collect over <?= $points ?> NLC and redeem for $<?= $usd ?> USD
            <?php endif; ?>
        </div>
        <div class="right">
            <button onclick="exchange(this, <?= $points ?>, <?= $usd ?>)" <?= $disabled ?>>Exchange</button>
        </div>
    </div>
<?php endforeach; ?>
</div>

<div id="toast">Success</div>

<script>
function exchange(button, points, reward) {
    fetch("", {
        method: "POST",
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        body: "points=" + points + "&reward=" + reward
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            showToast("Exchange successful!");
            let bal = document.getElementById("nlcBalance");
            bal.innerText = data.new_nlc;
            // Recheck available buttons
            document.querySelectorAll(".exchange-box button").forEach(btn => {
                const reqPoints = parseInt(btn.getAttribute("onclick").match(/\d+/)[0]);
                btn.disabled = (data.new_nlc < reqPoints || data.new_nlc < 50);
            });
        } else {
            showToast(data.msg || "Failed");
        }
    });
}

function showToast(msg) {
    let toast = document.getElementById("toast");
    toast.innerText = msg;
    toast.className = "show";
    setTimeout(() => { toast.className = toast.className.replace("show", ""); }, 2500);
}
</script>

</body>
</html>