<?php
session_start();
include 'db.php';

// Check if user is logged in
if (!isset($_SESSION['phone'])) {
    header("Location: login.php");
    exit;
}

// Fetch user's profile photo if you want dynamic background
$stmt = $conn->prepare("SELECT profile_photo FROM users WHERE phone = ?");
$stmt->execute([$_SESSION['phone']]);
$currentPhoto = $stmt->fetchColumn();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover"/>
  <title></title>
  <style>
    body {
      margin: 0;
      height: 100vh;
      background: #000 url('<?php echo $currentPhoto ? htmlspecialchars($currentPhoto) : "agentt.jpg"; ?>') 
                 no-repeat center center fixed;
      background-size: cover;
    }
  </style>
</head>
<body>
</body>
</html>